/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonXPathRuleQuery;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ViolationSuppressor {
    public static final ViolationSuppressor REGEX_SUPPRESSOR = new ViolationSuppressor(){

        @Override
        public String getId() {
            return "Regex";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            Optional<Pattern> regex = rv.getRule().getProperty(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
            if (regex.isPresent() && rv.getDescription() != null && regex.get().matcher(rv.getDescription()).matches()) {
                return new Report.SuppressedViolation(rv, this, regex.get().pattern());
            }
            return null;
        }
    };
    public static final ViolationSuppressor XPATH_SUPPRESSOR = new ViolationSuppressor(){

        @Override
        public String getId() {
            return "XPath";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            Rule rule = rv.getRule();
            Optional<String> xpath = rule.getProperty(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
            if (!xpath.isPresent()) {
                return null;
            }
            SaxonXPathRuleQuery rq = new SaxonXPathRuleQuery(xpath.get(), XPathVersion.DEFAULT, rule.getPropertiesByPropertyDescriptor(), node.getAstInfo().getLanguageProcessor().services().getXPathHandler(), DeprecatedAttrLogger.createForSuppression(rv.getRule()));
            if (!rq.evaluate(node).isEmpty()) {
                return new Report.SuppressedViolation(rv, this, xpath.get());
            }
            return null;
        }
    };
    public static final ViolationSuppressor NOPMD_COMMENT_SUPPRESSOR = new ViolationSuppressor(){

        @Override
        public String getId() {
            return "//NOPMD";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            Map<Integer, String> noPmd = node.getAstInfo().getSuppressionComments();
            if (noPmd.containsKey(rv.getBeginLine())) {
                return new Report.SuppressedViolation(rv, this, noPmd.get(rv.getBeginLine()));
            }
            return null;
        }
    };

    public String getId();

    public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation var1, @NonNull Node var2);

    public static @Nullable Report.SuppressedViolation suppressOrNull(List<ViolationSuppressor> suppressorList, RuleViolation rv, Node node) {
        for (ViolationSuppressor suppressor : suppressorList) {
            Report.SuppressedViolation suppressed = suppressor.suppressOrNull(rv, node);
            if (suppressed == null) continue;
            return suppressed;
        }
        return null;
    }
}

