/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBType {
    private static final Logger LOG = LoggerFactory.getLogger(DBType.class);
    private static final String INTERNAL_SETTINGS = "[Internal Settings]";
    private String propertiesSource;
    private Properties properties;
    private String driverClass;
    private String characterSet;
    private String sourceCodeTypes;
    private String languages;
    private int sourceCodeReturnType;

    public DBType(String dbType) throws Exception {
        this.properties = this.loadDBProperties(dbType);
    }

    public DBType(String subProtocol, String subnamePrefix) throws IOException {
        LOG.debug("subProtocol={}, subnamePrefix={}", (Object)subProtocol, (Object)subnamePrefix);
        if (null == subProtocol && null == subnamePrefix) {
            throw new RuntimeException("subProtocol and subnamePrefix cannot both be null");
        }
        this.properties = null;
        if (subnamePrefix != null) {
            this.properties = this.loadDBProperties(subnamePrefix);
        }
        if (this.properties == null && subProtocol != null) {
            this.properties = this.loadDBProperties(subProtocol);
        }
        if (subnamePrefix != null && this.properties != null) {
            LOG.debug("DBType found using subnamePrefix={}", (Object)subnamePrefix);
        } else if (subProtocol != null && this.properties != null) {
            LOG.debug("DBType found using subProtocol={}", (Object)subProtocol);
        } else {
            throw new RuntimeException(String.format("Could not locate DBType properties using subProtocol=%s and subnamePrefix=%s", subProtocol, subnamePrefix));
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private Properties loadDBProperties(String matchString) throws IOException {
        LOG.trace("Entering: loadDBProperties with {}", (Object)matchString);
        ResourceBundle resourceBundle = null;
        LOG.trace("class_path={}", (Object)System.getProperty("java.class.path"));
        File propertiesFile = new File(matchString);
        LOG.trace("Attempting File no file suffix: {}", (Object)matchString);
        try (InputStream stream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
            resourceBundle = new PropertyResourceBundle(stream);
            this.propertiesSource = propertiesFile.getAbsolutePath();
            LOG.trace("FileSystemWithoutExtension");
        }
        catch (NoSuchFileException notFoundOnFilesystemWithoutExtension) {
            LOG.trace("notFoundOnFilesystemWithoutExtension");
            LOG.trace("Attempting File with added file suffix: {}.properties", (Object)matchString);
            propertiesFile = new File(matchString + ".properties");
            try (InputStream stream2 = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
                resourceBundle = new PropertyResourceBundle(stream2);
                this.propertiesSource = propertiesFile.getAbsolutePath();
                LOG.trace("FileSystemWithExtension");
            }
            catch (NoSuchFileException notFoundOnFilesystemWithExtensionTackedOn) {
                LOG.trace("Attempting JARWithoutClassPrefix: {}", (Object)matchString);
                try {
                    resourceBundle = ResourceBundle.getBundle(matchString);
                    this.propertiesSource = "[[Internal Settings]]" + File.separator + matchString + ".properties";
                    LOG.trace("InJarWithoutPath");
                }
                catch (Exception notInJarWithoutPath) {
                    LOG.trace("Attempting JARWithClass prefix: {}.{}", (Object)DBType.class.getCanonicalName(), (Object)matchString);
                    try {
                        resourceBundle = ResourceBundle.getBundle(DBType.class.getPackage().getName() + "." + matchString);
                        this.propertiesSource = "[[Internal Settings]]" + File.separator + matchString + ".properties";
                        LOG.trace("found InJarWithPath");
                    }
                    catch (Exception notInJarWithPath) {
                        notInJarWithPath.printStackTrace();
                        notFoundOnFilesystemWithExtensionTackedOn.printStackTrace();
                        throw new RuntimeException(" Could not locate DBTYpe settings : " + matchString, notInJarWithPath);
                    }
                }
            }
        }
        Properties matchedProperties = DBType.getResourceBundleAsProperties(resourceBundle);
        resourceBundle = null;
        String saveLoadedFrom = this.getPropertiesSource();
        String extendedPropertyFile = (String)matchedProperties.remove("extends");
        if (null != extendedPropertyFile && !"".equals(extendedPropertyFile.trim())) {
            Properties extendedProperties = this.loadDBProperties(extendedPropertyFile.trim());
            extendedProperties.putAll((Map<?, ?>)matchedProperties);
            matchedProperties = extendedProperties;
        }
        this.propertiesSource = saveLoadedFrom;
        this.setProperties(matchedProperties);
        return matchedProperties;
    }

    public static Properties getResourceBundleAsProperties(ResourceBundle resourceBundle) {
        Properties properties = new Properties();
        for (String key : resourceBundle.keySet()) {
            properties.put(key, resourceBundle.getObject(key));
        }
        return properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.characterSet == null ? 0 : this.characterSet.hashCode());
        result = 31 * result + (this.driverClass == null ? 0 : this.driverClass.hashCode());
        result = 31 * result + (this.languages == null ? 0 : this.languages.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.propertiesSource == null ? 0 : this.propertiesSource.hashCode());
        result = 31 * result + this.sourceCodeReturnType;
        result = 31 * result + (this.sourceCodeTypes == null ? 0 : this.sourceCodeTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBType other = (DBType)obj;
        if (this.characterSet == null ? other.characterSet != null : !this.characterSet.equals(other.characterSet)) {
            return false;
        }
        if (this.driverClass == null ? other.driverClass != null : !this.driverClass.equals(other.driverClass)) {
            return false;
        }
        if (this.languages == null ? other.languages != null : !this.languages.equals(other.languages)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.propertiesSource == null ? other.propertiesSource != null : !this.propertiesSource.equals(other.propertiesSource)) {
            return false;
        }
        if (this.sourceCodeReturnType != other.sourceCodeReturnType) {
            return false;
        }
        return !(this.sourceCodeTypes == null ? other.sourceCodeTypes != null : !this.sourceCodeTypes.equals(other.sourceCodeTypes));
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getSourceCodeTypes() {
        return this.sourceCodeTypes;
    }

    public String getLanguages() {
        return this.languages;
    }

    public int getSourceCodeReturnType() {
        return this.sourceCodeReturnType;
    }

    public String getPropertiesSource() {
        return this.propertiesSource;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
        if (null != this.properties.getProperty("driver")) {
            this.driverClass = this.properties.getProperty("driver");
        }
        if (null != this.properties.getProperty("characterset")) {
            this.characterSet = this.properties.getProperty("characterset");
        }
        if (null != this.properties.getProperty("sourcecodetypes")) {
            this.sourceCodeTypes = this.properties.getProperty("sourcecodetypes");
        }
        if (null != this.properties.getProperty("languages")) {
            this.languages = this.properties.getProperty("languages");
        }
        if (null != this.properties.getProperty("returnType")) {
            LOG.trace("returnType={}", (Object)this.properties.getProperty("returnType"));
            this.sourceCodeReturnType = Integer.parseInt(this.properties.getProperty("returnType"));
        }
    }

    public String toString() {
        return DBType.class.getCanonicalName() + "@" + this.propertiesSource;
    }

    public static enum Property {
        USER("user", "Name of the connecting database user"),
        PASSWORD("password", "The connecting database user's password"),
        DRIVER("driver", "JDBC driver classname"),
        CHARACTERSET("characterset", "Reader character set"),
        LANGUAGES("languages", "Comma-separated list of PMD-supported languages"),
        SCHEMAS("schemas", "SchemaSpy compatible regular expression for schemas to be processed"),
        SOURCE_TYPES("sourcecodetypes", "Comma-separated list of supported source types"),
        SOURCE_NAMES("sourcecodenames", "Default comma-separated list of source code names to validate"),
        GET_SOURCE_CODE_STATEMENT("getSourceCodeStatement", "SQL92 or Oracle embedded SQL statement to retrieve  code source from the database catalogue"),
        RETURN_TYPE("returnType", "int equivalent of java.sql.Types return type of getSourceCodeStatement");

        private String name;
        private String description;

        private Property(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getPropertyName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

