/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleSetWriter;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.ResourceLoader;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractRuleSetFactoryTest {
    private static SAXParserFactory saxParserFactory;
    private static ValidateDefaultHandler validateDefaultHandler;
    private static SAXParser saxParser;
    protected Set<String> validXPathClassNames = new HashSet<String>();

    public AbstractRuleSetFactoryTest() {
        this.validXPathClassNames.add(XPathRule.class.getName());
    }

    @BeforeClass
    public static void init() throws Exception {
        saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setFeature("http://xml.org/sax/features/validation", true);
        saxParserFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
        saxParserFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        validateDefaultHandler = new ValidateDefaultHandler();
        saxParser = saxParserFactory.newSAXParser();
    }

    @Test
    public void testAllPMDBuiltInRulesMeetConventions() throws Exception {
        int invalidSinceAttributes = 0;
        int invalidExternalInfoURL = 0;
        int invalidClassName = 0;
        int invalidRegexSuppress = 0;
        int invalidXPathSuppress = 0;
        String messages = "";
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            RuleSet ruleSet = this.loadRuleSetByFileName(fileName);
            for (Rule rule : ruleSet.getRules()) {
                if (rule instanceof RuleReference) continue;
                Language language = rule.getLanguage();
                String group = fileName.substring(fileName.lastIndexOf(47) + 1);
                if ((group = group.substring(0, group.indexOf(".xml"))).indexOf(45) >= 0) {
                    group = group.substring(0, group.indexOf(45));
                }
                if (rule.getSince() == null) {
                    ++invalidSinceAttributes;
                    messages = messages + "Rule " + fileName + "/" + rule.getName() + " is missing 'since' attribute" + PMD.EOL;
                }
                if (rule.getExternalInfoUrl() == null || "".equalsIgnoreCase(rule.getExternalInfoUrl())) {
                    ++invalidExternalInfoURL;
                    messages = messages + "Rule " + fileName + "/" + rule.getName() + " is missing 'externalInfoURL' attribute" + PMD.EOL;
                } else {
                    String expectedExternalInfoURL = "https?://pmd.(sourceforge.net|github.io)/.+/pmd_rules_" + language.getTerseName() + "_" + FilenameUtils.getBaseName((String)fileName) + ".html#" + rule.getName().toLowerCase(Locale.ROOT);
                    if (rule.getExternalInfoUrl() == null || !rule.getExternalInfoUrl().matches(expectedExternalInfoURL)) {
                        ++invalidExternalInfoURL;
                        messages = messages + "Rule " + fileName + "/" + rule.getName() + " seems to have an invalid 'externalInfoURL' value (" + rule.getExternalInfoUrl() + "), it should be:" + expectedExternalInfoURL + PMD.EOL;
                    }
                }
                String expectedClassName = "net.sourceforge.pmd.lang." + language.getTerseName() + ".rule." + group + "." + rule.getName() + "Rule";
                if (!rule.getRuleClass().equals(expectedClassName) && !this.validXPathClassNames.contains(rule.getRuleClass())) {
                    ++invalidClassName;
                    messages = messages + "Rule " + fileName + "/" + rule.getName() + " seems to have an invalid 'class' value (" + rule.getRuleClass() + "), it should be:" + expectedClassName + PMD.EOL;
                }
                if (rule.getProperty((PropertyDescriptor)Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR) != null) {
                    ++invalidRegexSuppress;
                    messages = messages + "Rule " + fileName + "/" + rule.getName() + " should not have '" + Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR.name() + "', this is intended for end user customization only." + PMD.EOL;
                }
                if (rule.getProperty((PropertyDescriptor)Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR) == null) continue;
                ++invalidXPathSuppress;
                messages = messages + "Rule " + fileName + "/" + rule.getName() + " should not have '" + Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR.name() + "', this is intended for end user customization only." + PMD.EOL;
            }
        }
        if (invalidSinceAttributes > 0 || invalidExternalInfoURL > 0 || invalidClassName > 0 || invalidRegexSuppress > 0 || invalidXPathSuppress > 0) {
            Assert.fail((String)("All built-in PMD rules need 'since' attribute (" + invalidSinceAttributes + " are missing), a proper ExternalURLInfo (" + invalidExternalInfoURL + " are invalid), a class name meeting conventions (" + invalidClassName + " are invalid), no '" + Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR.name() + "' property (" + invalidRegexSuppress + " are invalid), and no '" + Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR.name() + "' property (" + invalidXPathSuppress + " are invalid)" + PMD.EOL + messages));
        }
    }

    @Test
    public void testXmlSchema() throws Exception {
        boolean allValid = true;
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            boolean valid = this.validateAgainstSchema(fileName);
            allValid = allValid && valid;
        }
        Assert.assertTrue((String)"All XML must parse without producing validation messages.", (boolean)allValid);
    }

    @Test
    public void testDtd() throws Exception {
        boolean allValid = true;
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            boolean valid = this.validateAgainstDtd(fileName);
            allValid = allValid && valid;
        }
        Assert.assertTrue((String)"All XML must parse without producing validation messages.", (boolean)allValid);
    }

    @Test
    public void testReadWriteRoundTrip() throws Exception {
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            this.testRuleSet(fileName);
        }
    }

    private List<String> getRuleSetFileNames() throws IOException, RuleSetNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        for (Language language : LanguageRegistry.getLanguages()) {
            result.addAll(this.getRuleSetFileNames(language.getTerseName()));
        }
        return result;
    }

    private List<String> getRuleSetFileNames(String language) throws IOException, RuleSetNotFoundException {
        ArrayList<String> ruleSetFileNames = new ArrayList<String>();
        try {
            Properties properties = new Properties();
            try (InputStream is = new ResourceLoader().loadClassPathResourceAsStreamOrThrow("rulesets/" + language + "/rulesets.properties");){
                properties.load(is);
            }
            String fileNames = properties.getProperty("rulesets.filenames");
            StringTokenizer st = new StringTokenizer(fileNames, ",");
            while (st.hasMoreTokens()) {
                ruleSetFileNames.add(st.nextToken());
            }
        }
        catch (RuleSetNotFoundException e) {
            System.err.println("No ruleset found for language " + language);
        }
        return ruleSetFileNames;
    }

    private RuleSet loadRuleSetByFileName(String ruleSetFileName) throws RuleSetNotFoundException {
        RuleSetFactory rsf = new RuleSetFactory();
        return rsf.createRuleSet(ruleSetFileName);
    }

    private boolean validateAgainstSchema(String fileName) throws IOException, RuleSetNotFoundException, ParserConfigurationException, SAXException {
        InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(fileName);
        boolean valid = this.validateAgainstSchema(inputStream);
        if (!valid) {
            System.err.println("Validation against XML Schema failed for: " + fileName);
        }
        return valid;
    }

    private boolean validateAgainstSchema(InputStream inputStream) throws IOException, RuleSetNotFoundException, ParserConfigurationException, SAXException {
        saxParser.parse(inputStream, (DefaultHandler)validateDefaultHandler.resetValid());
        inputStream.close();
        return validateDefaultHandler.isValid();
    }

    private boolean validateAgainstDtd(String fileName) throws IOException, RuleSetNotFoundException, ParserConfigurationException, SAXException {
        InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(fileName);
        boolean valid = this.validateAgainstDtd(inputStream);
        if (!valid) {
            System.err.println("Validation against DTD failed for: " + fileName);
        }
        return valid;
    }

    private boolean validateAgainstDtd(InputStream inputStream) throws IOException, RuleSetNotFoundException, ParserConfigurationException, SAXException {
        String file = this.readFullyToString(inputStream);
        inputStream.close();
        String rulesetNamespace = "http://pmd.sourceforge.net/ruleset/2.0.0";
        file = file.replaceAll("<\\?xml [ a-zA-Z0-9=\".-]*\\?>", "");
        file = file.replaceAll("xmlns=\"" + rulesetNamespace + "\"", "");
        file = file.replaceAll("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
        file = file.replaceAll("xsi:schemaLocation=\"" + rulesetNamespace + " https://pmd.sourceforge.io/ruleset_\\d_0_0.xsd\"", "");
        file = rulesetNamespace.equals("http://pmd.sourceforge.net/ruleset/2.0.0") ? "<?xml version=\"1.0\"?>" + PMD.EOL + "<!DOCTYPE ruleset SYSTEM \"https://pmd.sourceforge.io/ruleset_2_0_0.dtd\">" + PMD.EOL + file : "<?xml version=\"1.0\"?>" + PMD.EOL + "<!DOCTYPE ruleset>" + PMD.EOL + file;
        ByteArrayInputStream modifiedStream = new ByteArrayInputStream(file.getBytes());
        saxParser.parse((InputStream)modifiedStream, (DefaultHandler)validateDefaultHandler.resetValid());
        ((InputStream)modifiedStream).close();
        return validateDefaultHandler.isValid();
    }

    private String readFullyToString(InputStream inputStream) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder(65536);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = reader.readLine()) != null) {
            buf.append(line);
            buf.append(PMD.EOL);
        }
        reader.close();
        return buf.toString();
    }

    private static InputStream loadResourceAsStream(String resource) throws RuleSetNotFoundException {
        return new ResourceLoader().loadClassPathResourceAsStreamOrThrow(resource);
    }

    private void testRuleSet(String fileName) throws IOException, RuleSetNotFoundException, ParserConfigurationException, SAXException {
        RuleSet ruleSet1 = this.loadRuleSetByFileName(fileName);
        ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
        RuleSetWriter writer1 = new RuleSetWriter((OutputStream)outputStream1);
        writer1.write(ruleSet1);
        writer1.close();
        String xml2 = new String(outputStream1.toByteArray());
        RuleSetFactory ruleSetFactory = new RuleSetFactory();
        RuleSet ruleSet2 = ruleSetFactory.createRuleSet(AbstractRuleSetFactoryTest.createRuleSetReferenceId(xml2));
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        RuleSetWriter writer2 = new RuleSetWriter((OutputStream)outputStream2);
        writer2.write(ruleSet2);
        writer2.close();
        String xml3 = new String(outputStream2.toByteArray());
        RuleSet ruleSet3 = ruleSetFactory.createRuleSet(AbstractRuleSetFactoryTest.createRuleSetReferenceId(xml3));
        Assert.assertTrue((String)("1st roundtrip RuleSet XML is not valid against Schema (filename: " + fileName + ")"), (boolean)this.validateAgainstSchema(new ByteArrayInputStream(xml2.getBytes())));
        Assert.assertTrue((String)("2nd roundtrip RuleSet XML is not valid against Schema (filename: " + fileName + ")"), (boolean)this.validateAgainstSchema(new ByteArrayInputStream(xml3.getBytes())));
        Assert.assertTrue((String)("1st roundtrip RuleSet XML is not valid against DTD (filename: " + fileName + ")"), (boolean)this.validateAgainstDtd(new ByteArrayInputStream(xml2.getBytes())));
        Assert.assertTrue((String)("2nd roundtrip RuleSet XML is not valid against DTD (filename: " + fileName + ")"), (boolean)this.validateAgainstDtd(new ByteArrayInputStream(xml3.getBytes())));
        this.assertEqualsRuleSet("Original RuleSet and 1st roundtrip Ruleset not the same (filename: " + fileName + ")", ruleSet1, ruleSet2);
        this.assertEqualsRuleSet("1st roundtrip Ruleset and 2nd roundtrip RuleSet not the same (filename: " + fileName + ")", ruleSet2, ruleSet3);
        Assert.assertEquals((String)("1st roundtrip RuleSet XML and 2nd roundtrip RuleSet XML (filename: " + fileName + ")"), (Object)xml2, (Object)xml3);
    }

    private void assertEqualsRuleSet(String message, RuleSet ruleSet1, RuleSet ruleSet2) {
        Assert.assertEquals((String)(message + ", RuleSet name"), (Object)ruleSet1.getName(), (Object)ruleSet2.getName());
        Assert.assertEquals((String)(message + ", RuleSet description"), (Object)ruleSet1.getDescription(), (Object)ruleSet2.getDescription());
        Assert.assertEquals((String)(message + ", RuleSet exclude patterns"), (Object)ruleSet1.getExcludePatterns(), (Object)ruleSet2.getExcludePatterns());
        Assert.assertEquals((String)(message + ", RuleSet include patterns"), (Object)ruleSet1.getIncludePatterns(), (Object)ruleSet2.getIncludePatterns());
        Assert.assertEquals((String)(message + ", RuleSet rule count"), (long)ruleSet1.getRules().size(), (long)ruleSet2.getRules().size());
        for (int i = 0; i < ruleSet1.getRules().size(); ++i) {
            Rule rule1 = (Rule)((List)ruleSet1.getRules()).get(i);
            Rule rule2 = (Rule)((List)ruleSet2.getRules()).get(i);
            Assert.assertFalse((String)(message + ", Different RuleReference"), (rule1 instanceof RuleReference != rule2 instanceof RuleReference ? 1 : 0) != 0);
            if (rule1 instanceof RuleReference) {
                RuleReference ruleReference1 = (RuleReference)rule1;
                RuleReference ruleReference2 = (RuleReference)rule2;
                Assert.assertEquals((String)(message + ", RuleReference overridden language"), (Object)ruleReference1.getOverriddenLanguage(), (Object)ruleReference2.getOverriddenLanguage());
                Assert.assertEquals((String)(message + ", RuleReference overridden minimum language version"), (Object)ruleReference1.getOverriddenMinimumLanguageVersion(), (Object)ruleReference2.getOverriddenMinimumLanguageVersion());
                Assert.assertEquals((String)(message + ", RuleReference overridden maximum language version"), (Object)ruleReference1.getOverriddenMaximumLanguageVersion(), (Object)ruleReference2.getOverriddenMaximumLanguageVersion());
                Assert.assertEquals((String)(message + ", RuleReference overridden deprecated"), (Object)ruleReference1.isOverriddenDeprecated(), (Object)ruleReference2.isOverriddenDeprecated());
                Assert.assertEquals((String)(message + ", RuleReference overridden name"), (Object)ruleReference1.getOverriddenName(), (Object)ruleReference2.getOverriddenName());
                Assert.assertEquals((String)(message + ", RuleReference overridden description"), (Object)ruleReference1.getOverriddenDescription(), (Object)ruleReference2.getOverriddenDescription());
                Assert.assertEquals((String)(message + ", RuleReference overridden message"), (Object)ruleReference1.getOverriddenMessage(), (Object)ruleReference2.getOverriddenMessage());
                Assert.assertEquals((String)(message + ", RuleReference overridden external info url"), (Object)ruleReference1.getOverriddenExternalInfoUrl(), (Object)ruleReference2.getOverriddenExternalInfoUrl());
                Assert.assertEquals((String)(message + ", RuleReference overridden priority"), (Object)ruleReference1.getOverriddenPriority(), (Object)ruleReference2.getOverriddenPriority());
                Assert.assertEquals((String)(message + ", RuleReference overridden examples"), (Object)ruleReference1.getOverriddenExamples(), (Object)ruleReference2.getOverriddenExamples());
            }
            Assert.assertEquals((String)(message + ", Rule name"), (Object)rule1.getName(), (Object)rule2.getName());
            Assert.assertEquals((String)(message + ", Rule class"), (Object)rule1.getRuleClass(), (Object)rule2.getRuleClass());
            Assert.assertEquals((String)(message + ", Rule description " + rule1.getName()), (Object)rule1.getDescription(), (Object)rule2.getDescription());
            Assert.assertEquals((String)(message + ", Rule message"), (Object)rule1.getMessage(), (Object)rule2.getMessage());
            Assert.assertEquals((String)(message + ", Rule external info url"), (Object)rule1.getExternalInfoUrl(), (Object)rule2.getExternalInfoUrl());
            Assert.assertEquals((String)(message + ", Rule priority"), (Object)rule1.getPriority(), (Object)rule2.getPriority());
            Assert.assertEquals((String)(message + ", Rule examples"), (Object)rule1.getExamples(), (Object)rule2.getExamples());
            List propertyDescriptors1 = rule1.getPropertyDescriptors();
            List propertyDescriptors2 = rule2.getPropertyDescriptors();
            Assert.assertEquals((String)(message + ", Rule property descriptor "), (Object)propertyDescriptors1, (Object)propertyDescriptors2);
            for (int j = 0; j < propertyDescriptors1.size(); ++j) {
                Object value1 = rule1.getProperty((PropertyDescriptor)propertyDescriptors1.get(j));
                Object value2 = rule2.getProperty((PropertyDescriptor)propertyDescriptors2.get(j));
                if (((PropertyDescriptor)propertyDescriptors1.get(j)).type() == Pattern.class) {
                    value1 = ((Pattern)value1).pattern();
                    value2 = ((Pattern)value2).pattern();
                }
                Assert.assertEquals((String)(message + ", Rule property value " + j), (Object)value1, (Object)value2);
            }
            Assert.assertEquals((String)(message + ", Rule property descriptor count"), (long)propertyDescriptors1.size(), (long)propertyDescriptors2.size());
        }
    }

    protected static RuleSetReferenceId createRuleSetReferenceId(final String ruleSetXml) {
        return new RuleSetReferenceId(null){

            public InputStream getInputStream(ResourceLoader resourceLoader) throws RuleSetNotFoundException {
                try {
                    return new ByteArrayInputStream(ruleSetXml.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    return null;
                }
            }
        };
    }

    private static class ValidateDefaultHandler
    extends DefaultHandler {
        private boolean valid = true;
        private final Map<String, String> schemaMapping = new HashMap<String, String>();

        ValidateDefaultHandler() {
            this.schemaMapping.put("https://pmd.sourceforge.io/ruleset_2_0_0.xsd", "ruleset_2_0_0.xsd");
            this.schemaMapping.put("https://pmd.sourceforge.io/ruleset_2_0_0.dtd", "ruleset_2_0_0.dtd");
        }

        public ValidateDefaultHandler resetValid() {
            this.valid = true;
            return this;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.log("Error", e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.log("FatalError", e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.log("Warning", e);
        }

        private void log(String prefix, SAXParseException e) {
            String message = prefix + " at (" + e.getLineNumber() + ", " + e.getColumnNumber() + "): " + e.getMessage();
            System.err.println(message);
            this.valid = false;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            String resource = this.schemaMapping.get(systemId);
            if (resource != null) {
                try {
                    InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(resource);
                    return new InputSource(inputStream);
                }
                catch (RuleSetNotFoundException e) {
                    System.err.println(e.getMessage());
                    throw new IOException(e.getMessage());
                }
            }
            throw new IllegalArgumentException("No clue how to handle: publicId=" + publicId + ", systemId=" + systemId);
        }
    }
}

