/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUpdater
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)PropertyUpdater.class);
    private Map properties;

    public void updateProperties(AbstractContext abstractContext) {
        log.debug((Object)("Updating props in " + abstractContext));
        if (abstractContext != null) {
            Iterator iter = this.properties.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                PropertyDifference propDiff = (PropertyDifference)this.properties.get(key);
                if (propDiff.isRemoved()) {
                    abstractContext.removePropertyNonReplicable(key);
                    continue;
                }
                abstractContext.setNonReplicableProperty(key, propDiff.getValue());
                log.debug((Object)("Added prop=" + key + ", value=" + propDiff.getValue() + " to context " + abstractContext));
            }
        }
    }

    public void addContextProperty(PropertyDifference diff) {
        this.properties.put(diff.getKey(), diff);
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Map getProperties() {
        return this.properties;
    }
}

