/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AckManager {
    private static Log log = LogFactory.getLog((Class)AckManager.class);
    private static Map messageAckTable = new Hashtable();

    public static void addInitialAcknowledgement(ContextClusteringCommand command) {
        messageAckTable.put(command.getUniqueId(), new MessageACK(command));
    }

    public static void addAcknowledgement(String messageUniqueId, String memberId) {
        MessageACK ack = (MessageACK)messageAckTable.get(messageUniqueId);
        if (ack != null && !ack.hasACKed(memberId)) {
            ack.addACK(memberId);
        }
    }

    public static boolean isMessageAcknowledged(String messageUniqueId, ChannelSender sender) throws ClusteringFault {
        boolean isAcknowledged = false;
        MessageACK ack = (MessageACK)messageAckTable.get(messageUniqueId);
        Member[] members = sender.getChannel().getMembers();
        if (members.length == 0) {
            isAcknowledged = true;
        } else {
            for (int i = 0; i < members.length; ++i) {
                Member member = members[i];
                String memberHost = TribesUtil.getHost(member);
                if (member.isReady() && !ack.hasACKed(memberHost)) {
                    log.debug((Object)("[NO ACK] from member " + memberHost));
                    if (member.getMemberAliveTime() < 5000L && !ack.isRestransmittedToMember(memberHost)) {
                        sender.sendToMember(ack.getCommand(), member);
                        log.debug((Object)("Retransimitting msg " + ack.getCommand().getUniqueId() + " to member " + memberHost));
                    }
                    isAcknowledged = false;
                    break;
                }
                isAcknowledged = true;
            }
        }
        if (isAcknowledged) {
            messageAckTable.remove(messageUniqueId);
        }
        return isAcknowledged;
    }

    private static class MessageACK {
        private ContextClusteringCommand command;
        private List memberList = new Vector();
        private List retransmittedList = new ArrayList();

        public MessageACK(ContextClusteringCommand command) {
            this.command = command;
        }

        public void addACK(String memberId) {
            this.memberList.add(memberId);
        }

        public ContextClusteringCommand getCommand() {
            return this.command;
        }

        public boolean hasACKed(String memberId) {
            return this.memberList.contains(memberId);
        }

        public void addToRestransmittedList(String memberId) {
            this.retransmittedList.add(memberId);
        }

        public boolean isRestransmittedToMember(String memberId) {
            return this.retransmittedList.contains(memberId);
        }
    }
}

