/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.context.commands.ContextClusteringCommandCollection;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.clustering.control.AckCommand;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationResponseCommand;
import org.apache.axis2.clustering.control.GetStateResponseCommand;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.TribesControlCommandProcessor;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelListener
implements org.apache.catalina.tribes.ChannelListener {
    private static final Log log = LogFactory.getLog((Class)ChannelListener.class);
    private DefaultContextManager contextManager;
    private DefaultConfigurationManager configurationManager;
    private TribesControlCommandProcessor controlCommandProcessor;
    private ChannelSender channelSender;
    private ConfigurationContext configurationContext;

    public ChannelListener(ConfigurationContext configurationContext, DefaultConfigurationManager configurationManager, DefaultContextManager contextManager, TribesControlCommandProcessor controlCommandProcessor, ChannelSender sender) {
        this.configurationManager = configurationManager;
        this.contextManager = contextManager;
        this.controlCommandProcessor = controlCommandProcessor;
        this.channelSender = sender;
        this.configurationContext = configurationContext;
    }

    public void setContextManager(DefaultContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void setConfigurationManager(DefaultConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean accept(Serializable msg, Member sender) {
        return true;
    }

    public void messageReceived(Serializable msg, Member sender) {
        if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null && !(msg instanceof GetStateResponseCommand) && !(msg instanceof GetConfigurationResponseCommand)) {
            return;
        }
        log.debug((Object)("RECEIVED MESSAGE " + msg + " from " + TribesUtil.getHost(sender)));
        try {
            this.processMessage(msg, sender);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void processMessage(Serializable msg, Member sender) throws ClusteringFault {
        if (msg instanceof ContextClusteringCommand && this.contextManager != null) {
            ContextClusteringCommand ctxCmd = (ContextClusteringCommand)msg;
            this.contextManager.process(ctxCmd);
            if (msg instanceof ContextClusteringCommandCollection || msg instanceof UpdateContextCommand) {
                AckCommand ackCmd = new AckCommand(ctxCmd.getUniqueId());
                this.channelSender.sendToMember(ackCmd, sender);
            }
        } else if (msg instanceof ConfigurationClusteringCommand && this.configurationManager != null) {
            this.configurationManager.process((ConfigurationClusteringCommand)msg);
        } else if (msg instanceof ControlCommand && this.controlCommandProcessor != null) {
            this.controlCommandProcessor.process((ControlCommand)msg, sender);
        }
    }
}

