/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceDeployer
implements Deployer {
    private static final Log log = LogFactory.getLog((Class)ServiceDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        boolean isDirectory = deploymentFileData.getFile().isDirectory();
        StringWriter errorWriter = new StringWriter();
        ArchiveReader archiveReader = new ArchiveReader();
        String serviceStatus = "";
        try {
            deploymentFileData.setClassLoader(isDirectory, this.axisConfig.getServiceClassLoader(), (File)this.axisConfig.getParameterValue("artifactsDIR"));
            HashMap wsdlservice = archiveReader.processWSDLs(deploymentFileData);
            if (wsdlservice != null && wsdlservice.size() > 0) {
                Iterator services = wsdlservice.values().iterator();
                while (services.hasNext()) {
                    AxisService service = (AxisService)services.next();
                    Iterator operations = service.getOperations();
                    while (operations.hasNext()) {
                        AxisOperation axisOperation = (AxisOperation)operations.next();
                        this.axisConfig.getPhasesInfo().setOperationPhases(axisOperation);
                    }
                }
            }
            AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
            serviceGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
            ArrayList serviceList = archiveReader.processServiceGroup(deploymentFileData.getAbsolutePath(), deploymentFileData, serviceGroup, isDirectory, wsdlservice, this.configCtx);
            DeploymentEngine.addServiceGroup(serviceGroup, serviceList, deploymentFileData.getFile().toURL(), deploymentFileData, this.axisConfig);
            log.info((Object)Messages.getMessage("deployingws", deploymentFileData.getName()));
        }
        catch (DeploymentException de) {
            de.printStackTrace();
            log.error((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), de.getMessage()), (Throwable)de);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            de.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw de;
        }
        catch (AxisFault axisFault) {
            log.error((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), axisFault.getMessage()), (Throwable)axisFault);
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            axisFault.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(axisFault);
        }
        catch (Exception e) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                log.info((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            e.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(e);
        }
        catch (Throwable t) {
            if (log.isInfoEnabled()) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                log.info((Object)Messages.getMessage("invalidservice", deploymentFileData.getName(), sw.getBuffer().toString()));
            }
            PrintWriter error_ptintWriter = new PrintWriter(errorWriter);
            t.printStackTrace(error_ptintWriter);
            serviceStatus = "Error:\n" + errorWriter.toString();
            throw new DeploymentException(new Exception(t));
        }
        finally {
            if (serviceStatus.startsWith("Error:")) {
                this.axisConfig.getFaultyServices().put(deploymentFileData.getFile().getAbsolutePath(), serviceStatus);
            }
        }
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void unDeploy(String fileName) throws DeploymentException {
        try {
            fileName = DeploymentEngine.getAxisServiceName(fileName);
            AxisServiceGroup serviceGroup = this.axisConfig.removeServiceGroup(fileName);
            if (serviceGroup != null) {
                this.configCtx.removeServiceGroupContext(serviceGroup);
                log.info((Object)Messages.getMessage("serviceremoved", fileName));
            } else {
                this.axisConfig.removeFaultyService(fileName);
            }
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService(fileName);
            throw new DeploymentException(axisFault);
        }
    }
}

