/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingValidationHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog((Class)AddressingValidationHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Object flag = msgContext.getProperty("IsAddressingProcessed");
        if (log.isTraceEnabled()) {
            log.trace((Object)("invoke: IS_ADDR_INFO_ALREADY_PROCESSED=" + flag));
        }
        if (JavaUtils.isTrueExplicitly(flag) && JavaUtils.isTrue(msgContext.getProperty("addressing.validateAction"), true)) {
            this.checkAction(msgContext);
            this.checkMessageIDHeader(msgContext);
        }
        if (JavaUtils.isFalseExplicitly(flag)) {
            this.checkUsingAddressing(msgContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void checkUsingAddressing(MessageContext msgContext) throws AxisFault {
        if (msgContext.getAxisService() == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"checkUsingAddressing: axisService null, cannot check UsingAddressing");
            }
            return;
        }
        String addressingFlag = msgContext.getAxisService().getWSAddressingFlag();
        if (log.isTraceEnabled()) {
            log.trace((Object)("checkUsingAddressing: WSAddressingFlag=" + addressingFlag));
        }
        if ("required".equals(addressingFlag)) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(msgContext, "Action");
        }
    }

    private void checkAnonymous(MessageContext msgContext) throws AxisFault {
        String anonymous = AddressingHelper.getAnonymousParameterValue(msgContext.getAxisOperation());
        if (log.isTraceEnabled()) {
            log.trace((Object)("checkAnonymous: Anonymous=" + anonymous));
        }
        if ("required".equals(anonymous)) {
            EndpointReference anonEPR;
            if (AddressingHelper.isReplyRedirected(msgContext)) {
                anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                msgContext.setReplyTo(anonEPR);
                msgContext.setFaultTo(anonEPR);
                AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault(msgContext, "ReplyTo");
            }
            if (AddressingHelper.isFaultRedirected(msgContext)) {
                anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                msgContext.setReplyTo(anonEPR);
                msgContext.setFaultTo(anonEPR);
                AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault(msgContext, "FaultTo");
            }
        } else if ("prohibited".equals(anonymous)) {
            if (!AddressingHelper.isReplyRedirected(msgContext)) {
                AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault(msgContext, "ReplyTo");
            }
            if (!AddressingHelper.isFaultRedirected(msgContext)) {
                AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault(msgContext, "FaultTo");
            }
        }
    }

    private void checkAction(MessageContext msgContext) throws AxisFault {
        if (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null) {
            AddressingFaultsHelper.triggerActionNotSupportedFault(msgContext, msgContext.getWSAAction());
        }
    }

    private void checkMessageIDHeader(MessageContext msgContext) throws AxisFault {
        String messageId;
        String namespace = (String)msgContext.getProperty("WSAddressingVersion");
        if (!"http://www.w3.org/2005/08/addressing".equals(namespace)) {
            return;
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        String mep = axisOperation.getMessageExchangePattern();
        int mepConstant = Utils.getAxisSpecifMEPConstant(mep);
        if (!(mepConstant != 12 && mepConstant != 13 && mepConstant != 11 || (messageId = msgContext.getOptions().getMessageId()) != null && !"".equals(messageId))) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault(msgContext, "MessageID");
        }
    }
}

