/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;

public class PolicySubject {
    private boolean updated = false;
    private HashMap attachedPolicyComponents = new HashMap();

    public void attachPolicy(Policy policy) {
        String key = policy.getName();
        if (key == null && (key = policy.getId()) == null) {
            key = UUIDGenerator.getUUID();
            policy.setId(key);
        }
        this.attachPolicyComponent(key, (PolicyComponent)policy);
    }

    public void attachPolicyReference(PolicyReference reference) {
        this.attachedPolicyComponents.put(reference.getURI(), reference);
    }

    public void attachPolicyComponents(List policyComponents) {
        Iterator iterator = policyComponents.iterator();
        while (iterator.hasNext()) {
            this.attachPolicyComponent((PolicyComponent)iterator.next());
        }
    }

    public void attachPolicyComponent(PolicyComponent policyComponent) {
        if (policyComponent instanceof Policy) {
            this.attachPolicy((Policy)policyComponent);
        } else if (policyComponent instanceof PolicyReference) {
            this.attachPolicyReference((PolicyReference)policyComponent);
        } else {
            throw new IllegalArgumentException("Invalid top level policy component type");
        }
    }

    public void attachPolicyComponent(String key, PolicyComponent policyComponent) {
        this.attachedPolicyComponents.put(key, policyComponent);
        if (!this.isUpdated()) {
            this.setUpdated(true);
        }
    }

    public PolicyComponent getAttachedPolicyComponent(String key) {
        return (PolicyComponent)this.attachedPolicyComponents.get(key);
    }

    public Collection getAttachedPolicyComponents() {
        return this.attachedPolicyComponents.values();
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public void updatePolicy(Policy policy) {
        String key;
        String string = key = policy.getName() != null ? policy.getName() : policy.getId();
        if (key == null) {
            throw new IllegalArgumentException("policy doesn't have a name or an id ");
        }
        this.attachedPolicyComponents.put(key, policy);
        if (!this.isUpdated()) {
            this.setUpdated(true);
        }
    }

    public void detachPolicyComponent(String key) {
        this.attachedPolicyComponents.remove(key);
        if (!this.isUpdated()) {
            this.setUpdated(true);
        }
    }

    public void clear() {
        this.attachedPolicyComponents.clear();
        if (!this.isUpdated()) {
            this.setUpdated(true);
        }
    }
}

