/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAAJUtil {
    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env) {
        SOAPFactory factory;
        String nsURI;
        env.build();
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory((String)"dom");
        if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            factory = metaFactory.getSOAP11Factory();
        } else {
            nsURI = "http://www.w3.org/2003/05/soap-envelope";
            factory = metaFactory.getSOAP12Factory();
        }
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
        SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
        envelope.build();
        Element envElem = (Element)envelope;
        return envElem.getOwnerDocument();
    }

    public static Element toDOOMSOAPEnvelope(SOAPEnvelope env) {
        SOAPFactory factory;
        String nsURI;
        env.build();
        OMMetaFactory metaFactory = OMAbstractFactory.getMetaFactory((String)"dom");
        if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            factory = metaFactory.getSOAP11Factory();
        } else {
            nsURI = "http://www.w3.org/2003/05/soap-envelope";
            factory = metaFactory.getSOAP11Factory();
        }
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
        SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
        envelope.build();
        return (Element)envelope;
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOOMDocument(Document doc) {
        OMElement docElem = (OMElement)doc.getDocumentElement();
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(docElem.getXMLStreamReader(), null);
        return stAXSOAPModelBuilder.getSOAPEnvelope();
    }

    public static SOAPEnvelope toOMSOAPEnvelope(Element elem) {
        OMElement docElem = (OMElement)elem;
        StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(docElem.getXMLStreamReader(), null);
        return stAXSOAPModelBuilder.getSOAPEnvelope();
    }

    public static SOAPEnvelope toOMSOAPEnvelope(SOAPMessage message) throws SOAPException {
        Attachments attachments = new Attachments();
        Iterator it = message.getAttachments();
        while (it.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)it.next();
            String contentId = attachment.getContentId();
            if (contentId == null) continue;
            DataHandler dh = attachment.getDataHandler();
            if (dh == null) {
                throw new SOAPException("Attachment with NULL DataHandler");
            }
            if (contentId.startsWith("<") && contentId.endsWith(">")) {
                contentId = contentId.substring(1, contentId.length() - 1);
            }
            attachments.addDataHandler(contentId, dh);
        }
        OMElement docElem = (OMElement)message.getSOAPPart().getDocumentElement();
        MTOMStAXSOAPModelBuilder builder = new MTOMStAXSOAPModelBuilder(docElem.getXMLStreamReader(), attachments);
        return builder.getSOAPEnvelope();
    }

    public static Element toDOM(OMElement element) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        element.serialize((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(bais).getDocumentElement();
    }

    public static MimeHeaders copyMimeHeaders(MimeHeaders headers) {
        MimeHeaders result = new MimeHeaders();
        Iterator iterator = headers.getAllHeaders();
        while (iterator.hasNext()) {
            MimeHeader hdr = (MimeHeader)iterator.next();
            result.addHeader(hdr.getName(), hdr.getValue());
        }
        return result;
    }

    public static String normalizeContentType(String contentType) {
        int idx = contentType.indexOf(";");
        return (idx == -1 ? contentType : contentType.substring(0, idx)).trim().toLowerCase();
    }

    public static boolean compareContentTypes(String contentType1, String contentType2) {
        String ct1 = contentType1 == null ? "" : contentType1.trim().toLowerCase();
        String ct2 = contentType2 == null ? "" : contentType2.trim().toLowerCase();
        return ct1.equals(ct2);
    }
}

