/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.arc.Arc;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.impl.engine.DefaultReactiveExecutor;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.validator.PredicateValidatorDefinition;
import org.apache.camel.quarkus.core.CamelBeanQualifierResolver;
import org.apache.camel.quarkus.core.CamelQuarkusPackageScanClassResolver;
import org.apache.camel.quarkus.core.DisabledModelJAXBContextFactory;
import org.apache.camel.quarkus.core.DisabledModelToXMLDumper;
import org.apache.camel.quarkus.core.DisabledModelToYAMLDumper;
import org.apache.camel.quarkus.core.DisabledPredicateValidatorReifier;
import org.apache.camel.quarkus.core.DisabledValidateReifier;
import org.apache.camel.quarkus.core.FastComponentNameResolver;
import org.apache.camel.quarkus.core.FastFactoryFinderResolver;
import org.apache.camel.quarkus.core.FastTypeConverter;
import org.apache.camel.quarkus.core.RegistryRoutesLoader;
import org.apache.camel.quarkus.core.RegistryRoutesLoaders;
import org.apache.camel.quarkus.core.RuntimeRegistry;
import org.apache.camel.quarkus.core.StaticAnnotationTypeConverterLoader;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.validator.ValidatorReifier;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.ModelToYAMLDumper;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;

@Recorder
public class CamelRecorder {
    public void registerCamelBeanQualifierResolver(String className, RuntimeValue<CamelBeanQualifierResolver> runtimeValue, Map<String, CamelBeanQualifierResolver> beanQualifiers) {
        if (beanQualifiers.containsKey(className)) {
            throw new RuntimeException("Duplicate CamelBeanQualifierResolver detected for class: " + className);
        }
        beanQualifiers.put(className, (CamelBeanQualifierResolver)runtimeValue.getValue());
    }

    public RuntimeValue<Registry> createRegistry(Map<String, CamelBeanQualifierResolver> beanQualifierResolvers) {
        return new RuntimeValue((Object)new RuntimeRegistry(beanQualifierResolvers));
    }

    public RuntimeValue<TypeConverterRegistry> createTypeConverterRegistry() {
        return new RuntimeValue((Object)new FastTypeConverter());
    }

    public void addTypeConverterLoader(RuntimeValue<TypeConverterRegistry> registry, RuntimeValue<TypeConverterLoader> loader) {
        ((TypeConverterLoader)loader.getValue()).load((TypeConverterRegistry)registry.getValue());
    }

    public void addTypeConverterLoader(RuntimeValue<TypeConverterRegistry> registry, Class<? extends TypeConverterLoader> loader) {
        try {
            loader.getConstructor(new Class[0]).newInstance(new Object[0]).load((TypeConverterRegistry)registry.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadAnnotatedConverters(RuntimeValue<TypeConverterRegistry> registry, Set<Class<?>> classes) {
        StaticAnnotationTypeConverterLoader.getInstance().load((TypeConverterRegistry)registry.getValue(), classes);
    }

    public void bind(RuntimeValue<Registry> runtime, String name, Class<?> type, Object instance) {
        ((Registry)runtime.getValue()).bind(name, type, instance);
    }

    public void bind(RuntimeValue<Registry> runtime, String name, Class<?> type, RuntimeValue<?> instance) {
        ((Registry)runtime.getValue()).bind(name, type, instance.getValue());
    }

    public void bind(RuntimeValue<Registry> runtime, String name, Class<?> type) {
        try {
            ((Registry)runtime.getValue()).bind(name, type, type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void disableXmlReifiers() {
        ProcessorReifier.registerReifier(ValidateDefinition.class, DisabledValidateReifier::new);
        ValidatorReifier.registerReifier(PredicateValidatorDefinition.class, DisabledPredicateValidatorReifier::new);
    }

    public RuntimeValue<ModelJAXBContextFactory> newDisabledModelJAXBContextFactory() {
        return new RuntimeValue((Object)new DisabledModelJAXBContextFactory());
    }

    public RuntimeValue<ModelToXMLDumper> newDisabledModelToXMLDumper() {
        return new RuntimeValue((Object)new DisabledModelToXMLDumper());
    }

    public RuntimeValue<ModelToYAMLDumper> newDisabledModelToYAMLDumper() {
        return new RuntimeValue((Object)new DisabledModelToYAMLDumper());
    }

    public RuntimeValue<RegistryRoutesLoader> newDefaultRegistryRoutesLoader() {
        return new RuntimeValue((Object)new RegistryRoutesLoaders.Default());
    }

    public RuntimeValue<RegistryRoutesLoader> newDisabledRegistryRoutesLoader() {
        return new RuntimeValue((Object)new RegistryRoutesLoaders.Disabled());
    }

    public RuntimeValue<FastFactoryFinderResolver.Builder> factoryFinderResolverBuilder() {
        return new RuntimeValue((Object)new FastFactoryFinderResolver.Builder());
    }

    public void factoryFinderResolverEntry(RuntimeValue<FastFactoryFinderResolver.Builder> builder, String resourcePath, Class<?> cl) {
        ((FastFactoryFinderResolver.Builder)builder.getValue()).entry(resourcePath, cl);
    }

    public RuntimeValue<FactoryFinderResolver> factoryFinderResolver(RuntimeValue<FastFactoryFinderResolver.Builder> builder) {
        return new RuntimeValue((Object)((FastFactoryFinderResolver.Builder)builder.getValue()).build());
    }

    public RuntimeValue<ModelReifierFactory> modelReifierFactory() {
        return new RuntimeValue((Object)new DefaultModelReifierFactory());
    }

    public RuntimeValue<ReactiveExecutor> createReactiveExecutor() {
        return new RuntimeValue((Object)new DefaultReactiveExecutor());
    }

    public RuntimeValue<StartupStepRecorder> newDefaultStartupStepRecorder() {
        return new RuntimeValue((Object)new DefaultStartupStepRecorder());
    }

    public Supplier<Endpoint> createEndpoint(String uri, Class<? extends Endpoint> endpointClass) {
        return () -> {
            CamelContext camelContext = (CamelContext)Arc.container().instance(CamelContext.class, new Annotation[0]).get();
            return camelContext.getEndpoint(uri, endpointClass);
        };
    }

    public Supplier<ProducerTemplate> createProducerTemplate(String uri) {
        return () -> {
            CamelContext camelContext = (CamelContext)Arc.container().instance(CamelContext.class, new Annotation[0]).get();
            ProducerTemplate result = camelContext.createProducerTemplate();
            if (uri != null) {
                result.setDefaultEndpointUri(uri);
            }
            return result;
        };
    }

    public Supplier<FluentProducerTemplate> createFluentProducerTemplate(String uri) {
        return () -> {
            CamelContext camelContext = (CamelContext)Arc.container().instance(CamelContext.class, new Annotation[0]).get();
            FluentProducerTemplate result = camelContext.createFluentProducerTemplate();
            if (uri != null) {
                result.setDefaultEndpointUri(uri);
            }
            return result;
        };
    }

    public <T> Supplier<T> produceProxy(Class<T> clazz, String uri) {
        return () -> {
            CamelContext camelContext = (CamelContext)Arc.container().instance(CamelContext.class, new Annotation[0]).get();
            BeanProxyFactory factory = PluginHelper.getBeanProxyFactory((CamelContext)camelContext);
            Endpoint endpoint = camelContext.getEndpoint(uri);
            try {
                return factory.createProxy(endpoint, true, new Class[]{clazz});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate proxy of type " + clazz.getName() + " on endpoint " + endpoint, e);
            }
        };
    }

    public RuntimeValue<ComponentNameResolver> createComponentNameResolver(Set<String> componentNames) {
        return new RuntimeValue((Object)new FastComponentNameResolver(componentNames));
    }

    public RuntimeValue<PackageScanClassResolver> createPackageScanClassResolver(Set<? extends Class<?>> packageScanClassCache) {
        return new RuntimeValue((Object)new CamelQuarkusPackageScanClassResolver(packageScanClassCache));
    }
}

