/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.model.Model;
import org.apache.camel.model.RoutesDefinition;

@Recorder
public class ConsumeRecorder {
    public RuntimeValue<RoutesDefinition> createRoutesDefinition() {
        RoutesDefinition routesDefinition = new RoutesDefinition();
        return new RuntimeValue((Object)routesDefinition);
    }

    public void addConsumeRoute(RuntimeValue<CamelContext> camelContext, RuntimeValue<RoutesDefinition> routesDefinition, String uri, RuntimeValue<Object> runtimeUriOrEndpoint, String beanName, String method) {
        RoutesDefinition routes = (RoutesDefinition)routesDefinition.getValue();
        if (uri != null) {
            routes.from(uri).bean((Object)beanName, method);
        } else {
            Object uriOrEndpoint = runtimeUriOrEndpoint.getValue();
            if (uriOrEndpoint instanceof Endpoint) {
                routes.from((Endpoint)uriOrEndpoint).bean((Object)beanName, method);
            } else {
                try {
                    String uriOrRef = (String)((CamelContext)camelContext.getValue()).getTypeConverter().mandatoryConvertTo(String.class, uriOrEndpoint);
                    routes.from(uriOrRef).bean((Object)beanName, method);
                }
                catch (NoTypeConversionAvailableException | TypeConversionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void addConsumeRoutesToContext(RuntimeValue<CamelContext> camelContext, RuntimeValue<RoutesDefinition> routesDefinition) {
        try {
            RoutesDefinition routes = (RoutesDefinition)routesDefinition.getValue();
            routes.setCamelContext((CamelContext)camelContext.getValue());
            ((Model)((CamelContext)camelContext.getValue()).getCamelContextExtension().getContextPlugin(Model.class)).addRouteDefinitions((Collection)routes.getRoutes());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add routes to context", e);
        }
    }

    public RuntimeValue<Object> getEndpointUri(RuntimeValue<CamelContext> camelContext, String beanName, String endpointMethodName) {
        Object bean = ((CamelContext)camelContext.getValue()).getRegistry().lookupByName(beanName);
        Method method = null;
        try {
            Class<?> cl = bean.getClass();
            do {
                method = Stream.of(cl.getDeclaredMethods()).filter(m -> m.getName().equals(endpointMethodName) && m.getParameterCount() == 0).findFirst().orElse(null);
                cl = cl.getSuperclass();
            } while (method == null && cl != Object.class);
            Object result = method.invoke(bean, new Object[0]);
            return new RuntimeValue(result);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

