/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.impl.engine.DefaultFactoryFinderResolver;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.support.ObjectHelper;
import org.jboss.logging.Logger;

public class FastFactoryFinderResolver
extends DefaultFactoryFinderResolver {
    private static final Logger LOG = Logger.getLogger(FastFactoryFinderResolver.class);
    private final Map<String, Class<?>> classMap;

    FastFactoryFinderResolver(Map<String, Class<?>> classMap) {
        this.classMap = classMap;
    }

    static String mapKey(String resourcePath, String key) {
        int len = resourcePath.length() + key.length() + 1;
        StringBuilder sb = new StringBuilder(len);
        if (resourcePath.startsWith("/")) {
            sb.append(resourcePath, 1, resourcePath.length());
        } else {
            sb.append(resourcePath);
        }
        if (!resourcePath.endsWith("/")) {
            sb.append("/");
        }
        sb.append(key);
        return sb.toString();
    }

    public FactoryFinder resolveFactoryFinder(ClassResolver classResolver, String resourcePath) {
        return new FastFactoryFinder(resourcePath);
    }

    public FactoryFinder resolveBootstrapFactoryFinder(ClassResolver classResolver, String resourcePath) {
        return new FastFactoryFinder(resourcePath);
    }

    public Map<String, Class<?>> getClassMap() {
        return Collections.unmodifiableMap(this.classMap);
    }

    public class FastFactoryFinder
    implements FactoryFinder {
        private final String path;

        FastFactoryFinder(String resourcePath) {
            this.path = resourcePath;
        }

        public String getResourcePath() {
            return this.path;
        }

        public Optional<Object> newInstance(String key) {
            return this.doNewInstance(key);
        }

        public <T> Optional<T> newInstance(String key, Class<T> type) {
            return this.doNewInstance(key).map(type::cast);
        }

        public Optional<Class<?>> findClass(String key) {
            String mapKey;
            Class<?> cl = FastFactoryFinderResolver.this.classMap.get(mapKey = FastFactoryFinderResolver.mapKey(this.path, key));
            LOG.tracef("Found a non-optional class for key %s: %s", (Object)mapKey, (Object)(cl == null ? "null" : cl.getName()));
            return Optional.ofNullable(cl);
        }

        public Optional<Class<?>> findOptionalClass(String key) {
            String mapKey;
            Class<?> cl = FastFactoryFinderResolver.this.classMap.get(mapKey = FastFactoryFinderResolver.mapKey(this.path, key));
            LOG.tracef("Found an optional class for key %s: %s", (Object)mapKey, (Object)(cl == null ? "null" : cl.getName()));
            return Optional.ofNullable(cl);
        }

        public void clear() {
        }

        private Optional<Object> doNewInstance(String key) {
            return this.findClass(key).map(ObjectHelper::newInstance);
        }
    }

    public static class Builder {
        private Map<String, Class<?>> classMap = new HashMap();

        public Builder entry(String resourcePath, Class<?> cl) {
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            this.classMap.put(resourcePath, cl);
            return this;
        }

        public FastFactoryFinderResolver build() {
            Map<String, Class<?>> cm = this.classMap;
            this.classMap = null;
            if (LOG.isDebugEnabled()) {
                cm.forEach((key, value) -> LOG.debugf("FactoryFinder entry " + key + ": " + value.getName(), new Object[0]));
            }
            return new FastFactoryFinderResolver(cm);
        }
    }
}

