/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.engine.DefaultInjector;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;

public class FastTypeConverterInjector
extends DefaultInjector {
    private final CamelContext context;
    private final CamelBeanPostProcessor postProcessor;

    public FastTypeConverterInjector(CamelContext context) {
        super(context);
        this.context = context;
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)context);
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        Object typeConverter = CamelContextHelper.findSingleByType((CamelContext)this.context, type);
        if (typeConverter == null) {
            typeConverter = ObjectHelper.newInstance(type);
        }
        CamelContextAware.trySetCamelContext((Object)typeConverter, (CamelContext)this.context);
        if (postProcessBean) {
            try {
                this.postProcessor.postProcessBeforeInitialization(typeConverter, typeConverter.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(typeConverter, typeConverter.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean: " + typeConverter, (Throwable)e);
            }
        }
        return (T)typeConverter;
    }
}

