/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.core;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.endpoint.EndpointRouteBuilder;
import org.apache.camel.builder.endpoint.LambdaEndpointRouteBuilder;
import org.apache.camel.quarkus.core.RegistryRoutesLoader;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistryRoutesLoaders {
    private RegistryRoutesLoaders() {
    }

    public static final class Default
    implements RegistryRoutesLoader {
        private static final Logger LOGGER = LoggerFactory.getLogger(Default.class);

        @Override
        public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
            ArrayList<RoutesBuilder> routes = new ArrayList<RoutesBuilder>();
            AntPathMatcher matcher = new AntPathMatcher();
            Set lrbs = camelContext.getRegistry().findByType(LambdaRouteBuilder.class);
            for (Object lrb : lrbs) {
                RouteBuilder rb = new RouteBuilder((LambdaRouteBuilder)lrb){
                    final /* synthetic */ LambdaRouteBuilder val$lrb;
                    {
                        this.val$lrb = lambdaRouteBuilder;
                    }

                    public void configure() throws Exception {
                        this.val$lrb.accept((Object)this);
                    }
                };
                routes.add((RoutesBuilder)rb);
            }
            Set lerbs = camelContext.getRegistry().findByType(LambdaEndpointRouteBuilder.class);
            for (final LambdaEndpointRouteBuilder lerb : lerbs) {
                EndpointRouteBuilder rb = new EndpointRouteBuilder(){

                    public void configure() throws Exception {
                        lerb.accept((Object)this);
                    }
                };
                routes.add((RoutesBuilder)rb);
            }
            Set builders = camelContext.getRegistry().findByType(RoutesBuilder.class);
            for (RoutesBuilder routesBuilder : builders) {
                String[] parts;
                boolean match;
                boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
                if (abs) continue;
                String name = routesBuilder.getClass().getName();
                if (name.contains("_ProducerMethod")) {
                    name = name.substring(0, name.indexOf("_ProducerMethod"));
                }
                name = name.replace("_ClientProxy", "");
                name = name.replace('.', '/');
                boolean bl = match = !"false".equals(includePattern);
                if (match && ObjectHelper.isNotEmpty((String)excludePattern)) {
                    for (String part : parts = excludePattern.split(",")) {
                        match = !matcher.match(part, name);
                        LOGGER.trace("Java RoutesBuilder: {} exclude filter: {} -> {}", new Object[]{name, part, match});
                        if (!match) break;
                    }
                }
                if (match && ObjectHelper.isNotEmpty((String)includePattern)) {
                    for (String part : parts = includePattern.split(",")) {
                        match = matcher.match(part, name);
                        LOGGER.trace("Java RoutesBuilder: {} include filter: {} -> {}", new Object[]{name, part, match});
                        if (match) break;
                    }
                }
                LOGGER.debug("Java RoutesBuilder: {} accepted by include/exclude filter: {}", (Object)name, (Object)match);
                if (!match) continue;
                routes.add(routesBuilder);
            }
            return routes;
        }
    }

    public static final class Disabled
    implements RegistryRoutesLoader {
        @Override
        public List<RoutesBuilder> collectRoutesFromRegistry(CamelContext camelContext, String excludePattern, String includePattern) {
            return Collections.emptyList();
        }
    }
}

