/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.runtime.Quarkus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.main.MainCommandLineSupport;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainShutdownStrategy;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.apache.camel.quarkus.core.CamelConfig;
import org.apache.camel.spi.HasCamelContext;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StringHelper;

public final class CamelMain
extends MainCommandLineSupport
implements HasCamelContext {
    private final AtomicBoolean engineStarted;
    private final CamelConfig.FailureRemedy failureRemedy;

    public CamelMain(CamelContext camelContext, CamelConfig.FailureRemedy failureRemedy) {
        this.camelContext = camelContext;
        this.engineStarted = new AtomicBoolean();
        this.failureRemedy = failureRemedy;
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = new RoutesConfigurer();
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
        }
        configurer.setBeanPostProcessor(PluginHelper.getBeanPostProcessor((CamelContext)camelContext));
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.configureRoutes(camelContext);
    }

    protected void configureStartupRecorder(CamelContext camelContext) {
        super.configureStartupRecorder(camelContext);
    }

    protected void doInit() throws Exception {
        SimpleMainShutdownStrategy shutdownStrategy = new SimpleMainShutdownStrategy();
        shutdownStrategy.addShutdownListener(() -> Quarkus.asyncExit((int)this.getExitCode()));
        this.setShutdownStrategy((MainShutdownStrategy)shutdownStrategy);
        super.doInit();
        this.initCamelContext();
    }

    protected void doStart() throws Exception {
        super.doStart();
        try {
            this.camelContext.start();
        }
        finally {
            if (this.getCamelContext().isVetoStarted()) {
                this.completed();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.camelContext.stop();
        this.engineStarted.set(false);
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        return this.camelContext.createProducerTemplate();
    }

    protected void initCamelContext() throws Exception {
        this.postProcessCamelContext(this.camelContext);
    }

    protected CamelContext createCamelContext() {
        throw new IllegalStateException("Should not be invoked");
    }

    public Collection<MainListener> getMainListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    public MainConfigurationProperties getMainConfigurationProperties() {
        return this.mainConfigurationProperties;
    }

    public void startEngine() throws Exception {
        if (this.shutdownStrategy.isRunAllowed() && this.engineStarted.compareAndSet(false, true)) {
            this.init();
            this.internalBeforeStart();
            this.beforeStart();
            this.start();
            this.afterStart();
        }
    }

    public void runEngine() throws Exception {
        if (this.shutdownStrategy.isRunAllowed()) {
            this.startEngine();
            this.waitUntilCompleted();
            try {
                if (this.camelTemplate != null) {
                    ServiceHelper.stopService((Service)this.camelTemplate);
                    this.camelTemplate = null;
                }
            }
            catch (Exception e) {
                LOG.debug("Error stopping camelTemplate due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
            }
            this.beforeStop();
            this.stop();
            this.afterStop();
        }
    }

    public int run(String[] args) throws Exception {
        this.parseArguments(args);
        this.runEngine();
        return this.getExitCode();
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        ArrayList<String> unknownArgs = new ArrayList<String>();
        boolean valid = true;
        while (!args.isEmpty()) {
            this.initOptions();
            String arg = args.removeFirst();
            boolean handled = false;
            for (MainCommandLineSupport.Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled || this.failureRemedy.equals((Object)CamelConfig.FailureRemedy.ignore)) continue;
            if (arg.length() >= 100) {
                String truncatedArg = String.format("%s...", StringHelper.limitLength((String)arg, (int)97));
                unknownArgs.add(truncatedArg);
            } else {
                unknownArgs.add(arg);
            }
            valid = false;
        }
        if (!valid) {
            System.out.println("Unknown option: " + String.join((CharSequence)" ", unknownArgs));
            System.out.println();
            this.showOptions();
            if (this.failureRemedy.equals((Object)CamelConfig.FailureRemedy.fail)) {
                this.completed();
                throw new RuntimeException("CamelMain encountered unknown arguments");
            }
        }
    }
}

