/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.main;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.main.BaseMainSupport;
import org.apache.camel.main.MainListener;
import org.apache.camel.quarkus.main.events.AfterConfigure;
import org.apache.camel.quarkus.main.events.AfterStart;
import org.apache.camel.quarkus.main.events.AfterStop;
import org.apache.camel.quarkus.main.events.BeforeConfigure;
import org.apache.camel.quarkus.main.events.BeforeInitialize;
import org.apache.camel.quarkus.main.events.BeforeStart;
import org.apache.camel.quarkus.main.events.BeforeStop;
import org.apache.camel.quarkus.main.events.MainEvent;
import org.apache.camel.util.function.Suppliers;

public class CamelMainEventBridge
implements MainListener {
    private final Supplier<BeanManager> beanManager = Suppliers.memorize(() -> ((ArcContainer)Arc.container()).beanManager());
    private final Set<String> observedMainEvents;

    public CamelMainEventBridge(Set<String> observedMainEvents) {
        this.observedMainEvents = observedMainEvents;
    }

    public void beforeInitialize(BaseMainSupport main) {
        if (this.observedMainEvents.contains(BeforeInitialize.class.getName())) {
            this.fireEvent(new BeforeInitialize(main));
        }
    }

    public void beforeConfigure(BaseMainSupport main) {
        if (this.observedMainEvents.contains(BeforeConfigure.class.getName())) {
            this.fireEvent(new BeforeConfigure(main));
        }
    }

    public void afterConfigure(BaseMainSupport main) {
        if (this.observedMainEvents.contains(AfterConfigure.class.getName())) {
            this.fireEvent(new AfterConfigure(main));
        }
    }

    public void beforeStart(BaseMainSupport main) {
        if (this.observedMainEvents.contains(BeforeStart.class.getName())) {
            this.fireEvent(new BeforeStart(main));
        }
    }

    public void afterStart(BaseMainSupport main) {
        if (this.observedMainEvents.contains(AfterStart.class.getName())) {
            this.fireEvent(new AfterStart(main));
        }
    }

    public void beforeStop(BaseMainSupport main) {
        if (this.observedMainEvents.contains(BeforeStop.class.getName())) {
            this.fireEvent(new BeforeStop(main));
        }
    }

    public void afterStop(BaseMainSupport main) {
        if (this.observedMainEvents.contains(AfterStop.class.getName())) {
            this.fireEvent(new AfterStop(main));
        }
    }

    private <T extends MainEvent> void fireEvent(T event) {
        this.beanManager.get().getEvent().select(MainEvent.class, new Annotation[0]).fire(event);
    }
}

