/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadBitString<C extends Asn1Container>
extends GrammarAction<C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReadBitString.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AbstractReadBitString(String name) {
        super(name);
    }

    protected abstract void setBitString(byte[] var1, C var2);

    @Override
    public final void action(C container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() != 5) {
            LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
        }
        byte[] data = tlv.getValue().getData();
        this.setBitString(data, container);
        if (IS_DEBUG) {
            LOG.debug("BITSTRING value : {}", (Object)Strings.dumpBytes((byte[])data));
        }
    }
}

