/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.ldap.extras.extended.PwdModifyRequest;

public class PasswordModifyRequest
extends AbstractAsn1Object {
    private PwdModifyRequest pwdModifyRequest;
    private int requestLength = 0;

    public PasswordModifyRequest(PwdModifyRequest pwdModifyRequest) {
        this.pwdModifyRequest = pwdModifyRequest;
    }

    public int computeLength() {
        int len;
        this.requestLength = 0;
        if (this.pwdModifyRequest.getUserIdentity() != null) {
            len = this.pwdModifyRequest.getUserIdentity().length;
            this.requestLength = 1 + BerValue.getNbBytes((int)len) + len;
        }
        if (this.pwdModifyRequest.getOldPassword() != null) {
            len = this.pwdModifyRequest.getOldPassword().length;
            this.requestLength += 1 + BerValue.getNbBytes((int)len) + len;
        }
        if (this.pwdModifyRequest.getNewPassword() != null) {
            len = this.pwdModifyRequest.getNewPassword().length;
            this.requestLength += 1 + BerValue.getNbBytes((int)len) + len;
        }
        return 1 + BerValue.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(BerValue.getBytes((int)this.requestLength));
        if (this.pwdModifyRequest.getUserIdentity() != null) {
            byte[] userIdentity = this.pwdModifyRequest.getUserIdentity();
            bb.put((byte)-128);
            bb.put(TLV.getBytes((int)userIdentity.length));
            bb.put(userIdentity);
        }
        if (this.pwdModifyRequest.getOldPassword() != null) {
            byte[] oldPassword = this.pwdModifyRequest.getOldPassword();
            bb.put((byte)-127);
            bb.put(TLV.getBytes((int)oldPassword.length));
            bb.put(oldPassword);
        }
        if (this.pwdModifyRequest.getNewPassword() != null) {
            byte[] newPassword = this.pwdModifyRequest.getNewPassword();
            bb.put((byte)-126);
            bb.put(TLV.getBytes((int)newPassword.length));
            bb.put(newPassword);
        }
        return bb;
    }

    public PwdModifyRequest getPwdModifyRequest() {
        return this.pwdModifyRequest;
    }

    public String toString() {
        return this.pwdModifyRequest.toString();
    }
}

