/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACIItem;
import org.apache.directory.shared.ldap.aci.ACIItemParser;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.StringValue;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.normalizers.ConcreteNameComponentNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleCache {
    private static final Logger LOG = LoggerFactory.getLogger(TupleCache.class);
    private final Map<String, List<ACITuple>> tuples = new HashMap<String, List<ACITuple>>();
    private final PartitionNexus nexus;
    private final ACIItemParser aciParser;
    private AttributeType prescriptiveAciAT;

    public TupleCache(CoreSession session) throws Exception {
        SchemaManager schemaManager = session.getDirectoryService().getSchemaManager();
        this.nexus = session.getDirectoryService().getPartitionNexus();
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(schemaManager);
        this.aciParser = new ACIItemParser((NameComponentNormalizer)ncn, schemaManager.getNormalizerMapping());
        this.prescriptiveAciAT = schemaManager.lookupAttributeTypeRegistry("prescriptiveACI");
        this.initialize(session);
    }

    private DN parseNormalized(SchemaManager schemaManager, String name) throws LdapException {
        DN dn = new DN(name);
        dn.normalize(schemaManager.getNormalizerMapping());
        return dn;
    }

    private void initialize(CoreSession session) throws Exception {
        Set suffixes = this.nexus.listSuffixes(null);
        for (String suffix : suffixes) {
            DN baseDn = this.parseNormalized(session.getDirectoryService().getSchemaManager(), suffix);
            EqualityNode filter = new EqualityNode("objectClass", (Value)new StringValue("accessControlSubentry"));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            SearchOperationContext searchOperationContext = new SearchOperationContext(session, baseDn, (ExprNode)filter, ctls);
            searchOperationContext.setAliasDerefMode(AliasDerefMode.NEVER_DEREF_ALIASES);
            EntryFilteringCursor results = this.nexus.search(searchOperationContext);
            while (results.next()) {
                ServerEntry result = (ServerEntry)results.get();
                DN subentryDn = result.getDn().normalize(session.getDirectoryService().getSchemaManager().getNormalizerMapping());
                EntryAttribute aci = result.get(this.prescriptiveAciAT);
                if (aci == null) {
                    LOG.warn("Found accessControlSubentry '" + subentryDn + "' without any " + "prescriptiveACI");
                    continue;
                }
                this.subentryAdded(subentryDn, result);
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveACI(ServerEntry entry) throws LdapException {
        EntryAttribute aci = entry.get(this.prescriptiveAciAT);
        if (aci == null) {
            if (entry.contains("objectClass", new String[]{"accessControlSubentry"}) || entry.contains("objectClass", new String[]{"2.5.17.1"})) {
                throw new LdapSchemaViolationException(ResultCodeEnum.OBJECT_CLASS_VIOLATION, "");
            }
            return false;
        }
        return true;
    }

    public void subentryAdded(DN normName, ServerEntry entry) throws LdapException {
        EntryAttribute aciAttr = entry.get(this.prescriptiveAciAT);
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        ArrayList entryTuples = new ArrayList();
        for (Value value : aciAttr) {
            String aci = value.getString();
            ACIItem item = null;
            try {
                item = this.aciParser.parse(aci);
                entryTuples.addAll(item.toTuples());
            }
            catch (ParseException e) {
                String msg = I18n.err((String)I18n.ERR_28, (Object[])new Object[]{item});
                LOG.error(msg, (Throwable)e);
            }
        }
        this.tuples.put(normName.getNormName(), entryTuples);
    }

    public void subentryDeleted(DN normName, ServerEntry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        this.tuples.remove(normName.toString());
    }

    public void subentryModified(DN normName, List<Modification> mods, ServerEntry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        for (Modification mod : mods) {
            if (!mod.getAttribute().instanceOf("prescriptiveACI")) continue;
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public void subentryModified(DN normName, ServerEntry mods, ServerEntry entry) throws LdapException {
        if (!this.hasPrescriptiveACI(entry)) {
            return;
        }
        if (mods.get(this.prescriptiveAciAT) != null) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<ACITuple> getACITuples(String subentryDn) {
        List<ACITuple> aciTuples = this.tuples.get(subentryDn);
        if (aciTuples == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aciTuples);
    }

    public void subentryRenamed(DN oldName, DN newName) {
        this.tuples.put(newName.getNormName(), this.tuples.remove(oldName.getNormName()));
    }
}

