/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxValueCountFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(SchemaManager schemaManager, Collection<ACITuple> tuples, OperationScope scope, OperationContext opContext, Collection<DN> userGroupNames, DN userName, ServerEntry userEntry, AuthenticationLevel authenticationLevel, DN entryName, String attrId, Value<?> attrValue, ServerEntry entry, Collection<MicroOperation> microOperations, ServerEntry entryView) throws NamingException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return tuples;
        }
        if (tuples.size() == 0) {
            return tuples;
        }
        Iterator<ACITuple> i = tuples.iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                ProtectedItem.MaxValueCount mvc;
                if (!(item instanceof ProtectedItem.MaxValueCount) || !this.isRemovable(mvc = (ProtectedItem.MaxValueCount)item, attrId, entryView)) continue;
                i.remove();
                continue block0;
            }
        }
        return tuples;
    }

    private boolean isRemovable(ProtectedItem.MaxValueCount mvc, String attrId, ServerEntry entryView) throws NamingException {
        for (ProtectedItem.MaxValueCountItem mvcItem : mvc) {
            EntryAttribute attr;
            int attrCount;
            if (!attrId.equalsIgnoreCase(mvcItem.getAttributeType()) || (attrCount = (attr = entryView.get(attrId)) == null ? 0 : attr.size()) <= mvcItem.getMaxCount()) continue;
            return true;
        }
        return false;
    }
}

