/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import java.util.List;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectiveAttributesSchemaChecker {
    private PartitionNexus nexus = null;
    private SchemaManager schemaManager = null;

    public CollectiveAttributesSchemaChecker(PartitionNexus nexus, SchemaManager schemaManager) {
        this.nexus = nexus;
        this.schemaManager = schemaManager;
    }

    void checkAdd(DN normName, ServerEntry entry) throws Exception {
        if (entry.hasObjectClass("collectiveAttributeSubentry")) {
            return;
        }
        if (this.containsAnyCollectiveAttributes(entry)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_241, (Object[])new Object[0]));
        }
    }

    public void checkModify(OperationContext opContext, DN normName, List<Modification> mods) throws Exception {
        ClonedServerEntry originalEntry = opContext.lookup(normName, ByPassConstants.LOOKUP_BYPASS);
        ServerEntry targetEntry = (ServerEntry)SchemaUtils.getTargetEntry(mods, (Entry)originalEntry);
        EntryAttribute targetObjectClasses = targetEntry.get("objectClass");
        if (targetObjectClasses.contains(new String[]{"collectiveAttributeSubentry"})) {
            return;
        }
        if (this.addsAnyCollectiveAttributes(mods)) {
            throw new LdapSchemaViolationException(ResultCodeEnum.OTHER, I18n.err((String)I18n.ERR_242, (Object[])new Object[0]));
        }
    }

    private boolean addsAnyCollectiveAttributes(List<Modification> mods) throws LdapException {
        for (Modification mod : mods) {
            ModificationOperation modOp;
            EntryAttribute attr = mod.getAttribute();
            AttributeType attrType = attr.getAttributeType();
            if (attrType == null) {
                if (!this.schemaManager.getAttributeTypeRegistry().contains(attr.getUpId())) {
                    throw new LdapInvalidAttributeTypeException();
                }
                attrType = this.schemaManager.lookupAttributeTypeRegistry(attr.getUpId());
            }
            if ((modOp = mod.getOperation()) != ModificationOperation.ADD_ATTRIBUTE && modOp != ModificationOperation.REPLACE_ATTRIBUTE || !attrType.isCollective()) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyCollectiveAttributes(ServerEntry entry) throws NamingException {
        Set attributeTypes = entry.getAttributeTypes();
        for (AttributeType attributeType : attributeTypes) {
            if (!attributeType.isCollective()) continue;
            return true;
        }
        return false;
    }
}

