/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.subtree;

import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.ExpressionEvaluator;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.util.NamespaceTools;

public class SubtreeEvaluator {
    private final Evaluator evaluator;

    public SubtreeEvaluator(OidRegistry oidRegistry, SchemaManager schemaManager) {
        this.evaluator = new ExpressionEvaluator(oidRegistry, schemaManager);
    }

    public boolean evaluate(SubtreeSpecification subtree, DN apDn, DN entryDn, ServerEntry entry) throws LdapException {
        DN baseRelativeRdn;
        DN dnEntryDn = entryDn;
        if (!NamespaceTools.isDescendant((DN)apDn, (DN)entryDn)) {
            return false;
        }
        DN apRelativeRdn = apDn.equals((Object)entryDn) ? new DN() : NamespaceTools.getRelativeName((DN)apDn, (DN)entryDn);
        if (subtree.getBase() != null && subtree.getBase().size() == 0) {
            baseRelativeRdn = apRelativeRdn;
        } else if (apRelativeRdn.equals((Object)subtree.getBase())) {
            baseRelativeRdn = new DN();
        } else {
            if (!NamespaceTools.isDescendant((DN)subtree.getBase(), (DN)apRelativeRdn)) {
                return false;
            }
            baseRelativeRdn = NamespaceTools.getRelativeName((DN)subtree.getBase(), (DN)apRelativeRdn);
        }
        if (subtree.getMaxBaseDistance() != -1 && subtree.getMaxBaseDistance() < baseRelativeRdn.size()) {
            return false;
        }
        if (subtree.getMinBaseDistance() > 0 && baseRelativeRdn.size() < subtree.getMinBaseDistance()) {
            return false;
        }
        for (DN chopBefore : subtree.getChopBeforeExclusions()) {
            if (!NamespaceTools.isDescendant((DN)chopBefore, (DN)baseRelativeRdn)) continue;
            return false;
        }
        for (DN chopAfter : subtree.getChopAfterExclusions()) {
            if (!NamespaceTools.isDescendant((DN)chopAfter, (DN)baseRelativeRdn) || chopAfter.equals((Object)baseRelativeRdn)) continue;
            return false;
        }
        if (subtree.getRefinement() != null) {
            return this.evaluator.evaluate(subtree.getRefinement(), dnEntryDn.getNormName(), entry);
        }
        return true;
    }
}

