/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.interceptor.context;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.interceptor.context.AbstractChangeOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;

public class RenameOperationContext
extends AbstractChangeOperationContext {
    private RDN newRdn;
    private DN newDn;
    private boolean delOldDn;
    private ClonedServerEntry alteredEntry;

    public RenameOperationContext(CoreSession session) {
        super(session);
    }

    public RenameOperationContext(CoreSession session, DN oldDn, RDN newRdn, boolean delOldDn) {
        super(session, oldDn);
        this.newRdn = newRdn;
        this.delOldDn = delOldDn;
    }

    public RenameOperationContext(CoreSession session, InternalModifyDnRequest modifyDnRequest) {
        super(session, modifyDnRequest.getName());
        this.newRdn = modifyDnRequest.getNewRdn();
        if (this.newRdn == null) {
            throw new IllegalStateException(I18n.err((String)I18n.ERR_328, (Object[])new Object[]{modifyDnRequest}));
        }
        this.delOldDn = modifyDnRequest.getDeleteOldRdn();
        this.requestControls = modifyDnRequest.getControls();
        if (this.requestControls.containsKey("2.16.840.1.113730.3.4.2")) {
            this.ignoreReferral();
        } else {
            this.throwReferral();
        }
    }

    public boolean getDelOldDn() {
        return this.delOldDn;
    }

    public void setDelOldDn(boolean delOldDn) {
        this.delOldDn = delOldDn;
    }

    public DN getNewDn() throws Exception {
        return this.newDn;
    }

    public RDN getNewRdn() {
        return this.newRdn;
    }

    public void setNewRdn(RDN newRdn) {
        this.newRdn = newRdn;
    }

    public void setNewDn(DN newDn) {
        this.newDn = newDn;
    }

    public String getName() {
        return MessageTypeEnum.MODIFYDN_REQUEST.name();
    }

    public ClonedServerEntry getAlteredEntry() {
        return this.alteredEntry;
    }

    public void setAlteredEntry(ClonedServerEntry alteredEntry) {
        this.alteredEntry = alteredEntry;
    }

    public String toString() {
        return "RenameContext for old DN '" + this.getDn().getName() + "'" + ", new RDN '" + this.newRdn + "'" + (this.delOldDn ? ", delete old Dn" : "");
    }
}

