/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AttributeTypeSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.ComparatorSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.DitContentRuleSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.DitStructureRuleSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.MatchingRuleSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.MatchingRuleUseSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.NameFormSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.NormalizerSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.ObjectClassSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.RegistrySynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.SchemaSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.SyntaxCheckerSynchronizer;
import org.apache.directory.server.core.api.schema.registries.synchronizers.SyntaxSynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrySynchronizerAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(RegistrySynchronizerAdaptor.class);
    private static final int COMPARATOR_INDEX = 0;
    private static final int NORMALIZER_INDEX = 1;
    private static final int SYNTAX_CHECKER_INDEX = 2;
    private static final int SYNTAX_INDEX = 3;
    private static final int MATCHING_RULE_INDEX = 4;
    private static final int ATTRIBUTE_TYPE_INDEX = 5;
    private static final int OBJECT_CLASS_INDEX = 6;
    private static final int MATCHING_RULE_USE_INDEX = 7;
    private static final int DIT_STRUCTURE_RULE_INDEX = 8;
    private static final int DIT_CONTENT_RULE_INDEX = 9;
    private static final int NAME_FORM_INDEX = 10;
    private static final Set<String> VALID_OU_VALUES = new HashSet<String>();
    private static final String[] META_OBJECT_CLASSES = new String[]{"metaComparator", "metaNormalizer", "metaSyntaxChecker", "metaSyntax", "metaMatchingRule", "metaAttributeType", "metaObjectClass", "metaMatchingRuleUse", "metaDITStructureRule", "metaDITContentRule", "metaNameForm"};
    private final SchemaManager schemaManager;
    private final AttributeType objectClassAT;
    private final RegistrySynchronizer[] registrySynchronizers = new RegistrySynchronizer[11];
    private final Map<String, RegistrySynchronizer> objectClass2synchronizerMap = new HashMap<String, RegistrySynchronizer>();
    private final SchemaSynchronizer schemaSynchronizer;

    public RegistrySynchronizerAdaptor(SchemaManager schemaManager) throws Exception {
        this.schemaManager = schemaManager;
        this.schemaSynchronizer = new SchemaSynchronizer(schemaManager);
        this.objectClassAT = schemaManager.lookupAttributeTypeRegistry("objectClass");
        this.registrySynchronizers[0] = new ComparatorSynchronizer(schemaManager);
        this.registrySynchronizers[1] = new NormalizerSynchronizer(schemaManager);
        this.registrySynchronizers[2] = new SyntaxCheckerSynchronizer(schemaManager);
        this.registrySynchronizers[3] = new SyntaxSynchronizer(schemaManager);
        this.registrySynchronizers[4] = new MatchingRuleSynchronizer(schemaManager);
        this.registrySynchronizers[5] = new AttributeTypeSynchronizer(schemaManager);
        this.registrySynchronizers[6] = new ObjectClassSynchronizer(schemaManager);
        this.registrySynchronizers[7] = new MatchingRuleUseSynchronizer(schemaManager);
        this.registrySynchronizers[8] = new DitStructureRuleSynchronizer(schemaManager);
        this.registrySynchronizers[9] = new DitContentRuleSynchronizer(schemaManager);
        this.registrySynchronizers[10] = new NameFormSynchronizer(schemaManager);
        ObjectClassRegistry ocReg = schemaManager.getObjectClassRegistry();
        for (int ii = 0; ii < META_OBJECT_CLASSES.length; ++ii) {
            ObjectClass oc = (ObjectClass)ocReg.lookup(META_OBJECT_CLASSES[ii]);
            this.objectClass2synchronizerMap.put(oc.getOid(), this.registrySynchronizers[ii]);
        }
    }

    public void add(AddOperationContext addContext) throws LdapException {
        String msg;
        Attribute oc = addContext.getEntry().get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            Entry entry = addContext.getEntry();
            synchronizer.add(entry);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            Entry entry = addContext.getEntry();
            this.schemaSynchronizer.add(entry);
            return;
        }
        if (oc.contains(new String[]{"organizationalUnit"})) {
            if (addContext.getDn().size() != 3) {
                msg = I18n.err((I18n)I18n.ERR_81, (Object[])new Object[0]);
                LOG.error(msg);
                throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, msg);
            }
            String ouValue = addContext.getDn().getRdn().getNormValue().getString();
            if (!VALID_OU_VALUES.contains(ouValue = Strings.toLowerCase((String)Strings.trim((String)ouValue)))) {
                String msg2 = I18n.err((I18n)I18n.ERR_82, (Object[])new Object[]{VALID_OU_VALUES});
                LOG.error(msg2);
                throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, msg2);
            }
            return;
        }
        msg = I18n.err((I18n)I18n.ERR_83, (Object[])new Object[]{addContext.getDn()});
        LOG.error(msg);
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
    }

    public void delete(DeleteOperationContext deleteContext, boolean doCascadeDelete) throws LdapException {
        Entry entry = deleteContext.getEntry();
        Attribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.delete(entry, doCascadeDelete);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.schemaSynchronizer.delete(entry, doCascadeDelete);
            return;
        }
        if (oc.contains(new String[]{"organizationalUnit"})) {
            if (deleteContext.getDn().size() != 3) {
                throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err((I18n)I18n.ERR_378, (Object[])new Object[0]));
            }
            String ouValue = deleteContext.getDn().getRdn().getNormValue().getString();
            if (!VALID_OU_VALUES.contains(ouValue = Strings.toLowerCase((String)Strings.trim((String)ouValue)))) {
                throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err((I18n)I18n.ERR_379, (Object[])new Object[]{VALID_OU_VALUES}));
            }
            return;
        }
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean doCascadeModify) throws LdapException {
        Entry entry = modifyContext.getEntry();
        Attribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            boolean hasModification = synchronizer.modify(modifyContext, targetEntry, doCascadeModify);
            return hasModification;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            boolean hasModification = this.schemaSynchronizer.modify(modifyContext, targetEntry, doCascadeModify);
            return hasModification;
        }
        if (oc.contains(new String[]{"schemaModificationAttributes"})) {
            return false;
        }
        LOG.error(String.format(I18n.err((I18n)I18n.ERR_84, (Object[])new Object[0]), modifyContext.getDn(), entry, modifyContext.getModItems()));
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void rename(RenameOperationContext renameContext, boolean doCascadeModify) throws LdapException {
        Entry originalEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        Attribute oc = originalEntry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.rename(originalEntry, renameContext.getNewRdn(), doCascadeModify);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.schemaSynchronizer.rename(originalEntry, renameContext.getNewRdn(), doCascadeModify);
            return;
        }
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void move(MoveOperationContext moveContext, Entry entry, boolean cascade) throws LdapException {
        Attribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.move(moveContext.getDn(), moveContext.getNewSuperior(), entry, cascade);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.schemaSynchronizer.move(moveContext.getDn(), moveContext.getNewSuperior(), entry, cascade);
            return;
        }
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext, Entry entry, boolean cascade) throws LdapException {
        Attribute oc = entry.get(this.objectClassAT);
        for (Value value : oc) {
            String oid = this.schemaManager.getObjectClassRegistry().getOidByName(value.getString());
            if (!this.objectClass2synchronizerMap.containsKey(oid)) continue;
            RegistrySynchronizer synchronizer = this.objectClass2synchronizerMap.get(oid);
            synchronizer.moveAndRename(moveAndRenameContext.getDn(), moveAndRenameContext.getNewSuperiorDn(), moveAndRenameContext.getNewRdn(), moveAndRenameContext.getDeleteOldRdn(), entry, cascade);
            return;
        }
        if (oc.contains(new String[]{"metaSchema"})) {
            this.schemaSynchronizer.moveAndRename(moveAndRenameContext.getDn(), moveAndRenameContext.getNewSuperiorDn(), moveAndRenameContext.getNewRdn(), moveAndRenameContext.getDeleteOldRdn(), entry, cascade);
            return;
        }
        throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM);
    }

    static {
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"normalizers"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"comparators"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"syntaxCheckers"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"syntaxes"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"matchingRules"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"matchingRuleUse"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"attributeTypes"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"objectClasses"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"nameForms"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"ditContentRules"));
        VALID_OU_VALUES.add(Strings.toLowerCase((String)"ditStructureRules"));
    }
}

