/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.constants;

import java.time.Duration;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;

public final class Constants {
    public static final String AUTO_CLOSE_ALERT = "alert.auto-close";
    public static final String COMMON_PROPERTIES_PATH = "/common.properties";
    public static final String FORMAT_SS = "%s%s";
    public static final String FORMAT_S_S = "%s/%s";
    public static final String FORMAT_S_S_COLON = "%s:%s";
    public static final String FOLDER_SEPARATOR = "/";
    public static final String RESOURCE_TYPE_FILE = "resources";
    public static final String RESOURCE_TYPE_UDF = "udfs";
    public static final String EMPTY_STRING = "";
    public static final String FS_DEFAULT_FS = "resource.hdfs.fs.defaultFS";
    public static final String HDFS_DEFAULT_FS = "fs.defaultFS";
    public static final String HADOOP_RM_STATE_ACTIVE = "ACTIVE";
    public static final String HADOOP_RESOURCE_MANAGER_HTTPADDRESS_PORT = "resource.manager.httpaddress.port";
    public static final String YARN_RESOURCEMANAGER_HA_RM_IDS = "yarn.resourcemanager.ha.rm.ids";
    public static final String YARN_APPLICATION_STATUS_ADDRESS = "yarn.application.status.address";
    public static final String YARN_JOB_HISTORY_STATUS_ADDRESS = "yarn.job.history.status.address";
    public static final String HDFS_ROOT_USER = "resource.hdfs.root.user";
    public static final String RESOURCE_UPLOAD_PATH = "resource.storage.upload.base.path";
    public static final String DATA_BASEDIR_PATH = "data.basedir.path";
    public static final String DOLPHINSCHEDULER_ENV_PATH = "dolphinscheduler.env.path";
    public static final String ENV_PATH = "dolphinscheduler_env.sh";
    public static final String RESOURCE_VIEW_SUFFIXES = "resource.view.suffixs";
    public static final String RESOURCE_VIEW_SUFFIXES_DEFAULT_VALUE = "txt,log,sh,bat,conf,cfg,py,java,sql,xml,hql,properties,json,yml,yaml,ini,js";
    public static final String DEVELOPMENT_STATE = "development.state";
    public static final String SUDO_ENABLE = "sudo.enable";
    public static final String RESOURCE_STORAGE_TYPE = "resource.storage.type";
    public static final String AWS_S3_BUCKET_NAME = "resource.aws.s3.bucket.name";
    public static final String AWS_END_POINT = "resource.aws.s3.endpoint";
    public static final String ALIBABA_CLOUD_OSS_BUCKET_NAME = "resource.alibaba.cloud.oss.bucket.name";
    public static final String ALIBABA_CLOUD_OSS_END_POINT = "resource.alibaba.cloud.oss.endpoint";
    public static final String GOOGLE_CLOUD_STORAGE_BUCKET_NAME = "resource.google.cloud.storage.bucket.name";
    public static final String GOOGLE_CLOUD_STORAGE_CREDENTIAL = "resource.google.cloud.storage.credential";
    public static final String AZURE_BLOB_STORAGE_CONNECTION_STRING = "resource.azure.blob.storage.connection.string";
    public static final String AZURE_BLOB_STORAGE_CONTAINER_NAME = "resource.azure.blob.storage.container.name";
    public static final String AZURE_BLOB_STORAGE_ACCOUNT_NAME = "resource.azure.blob.storage.account.name";
    public static final String HUAWEI_CLOUD_OBS_BUCKET_NAME = "resource.huawei.cloud.obs.bucket.name";
    public static final String HUAWEI_CLOUD_OBS_END_POINT = "resource.huawei.cloud.obs.endpoint";
    public static final String APPID_COLLECT = "appId.collect";
    public static final String DEFAULT_COLLECT_WAY = "log";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String PERIOD = ".";
    public static final String QUESTION = "?";
    public static final String SPACE = " ";
    public static final String SINGLE_SLASH = "/";
    public static final String DOUBLE_SLASH = "//";
    public static final String AT_SIGN = "@";
    public static final String SLASH = "/";
    public static final String SEMICOLON = ";";
    public static final String ADDRESS = "address";
    public static final String DATABASE = "database";
    public static final String OTHER = "other";
    public static final String USER = "user";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String IMPORT_SUFFIX = "_import_";
    public static final String COPY_SUFFIX = "_copy_";
    public static final int HTTP_CONNECT_TIMEOUT = 60000;
    public static final int HTTP_CONNECTION_REQUEST_TIMEOUT = 60000;
    public static final int SOCKET_TIMEOUT = 60000;
    public static final String HTTP_HEADER_UNKNOWN = "unKnown";
    public static final String HTTP_X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String HTTP_X_REAL_IP = "X-Real-IP";
    public static final String UTF_8 = "UTF-8";
    public static final Pattern REGEX_USER_NAME = Pattern.compile("^[a-zA-Z0-9._-]{3,39}$");
    public static final int READ_PERMISSION = 2;
    public static final int WRITE_PERMISSION = 4;
    public static final int EXECUTE_PERMISSION = 1;
    public static final int DEFAULT_ADMIN_PERMISSION = 7;
    public static final int DEFAULT_HASH_MAP_SIZE = 16;
    public static final int ALL_PERMISSIONS = 7;
    public static final int MAX_TASK_TIMEOUT = 86400;
    public static final String FLOWNODE_RUN_FLAG_FORBIDDEN = "FORBIDDEN";
    public static final String FLOWNODE_RUN_FLAG_NORMAL = "NORMAL";
    public static final String COMMON_TASK_TYPE = "common";
    public static final String DEFAULT = "default";
    public static final String PASSWORD = "password";
    public static final String XXXXXX = "******";
    public static final String NULL = "NULL";
    public static final String THREAD_NAME_MASTER_SERVER = "Master-Server";
    public static final String THREAD_NAME_WORKER_SERVER = "Worker-Server";
    public static final String THREAD_NAME_ALERT_SERVER = "Alert-Server";
    public static final String CRC_SUFFIX = ".crc";
    public static final String DEFAULT_CRON_STRING = "0 0 0 * * ? *";
    public static final long SLEEP_TIME_MILLIS = 1000L;
    public static final long SLEEP_TIME_MILLIS_SHORT = 100L;
    public static final Duration SERVER_CLOSE_WAIT_TIME = Duration.ofSeconds(3L);
    public static final String JAR = "jar";
    public static final String HADOOP = "hadoop";
    public static final String D = "-D";
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_FAILURE = -1;
    public static final int DEFINITION_FAILURE = -1;
    public static final int OPPOSITE_VALUE = -1;
    public static final int VERSION_FIRST = 1;
    public static final String FAILED = "FAILED";
    public static final String RUNNING = "RUNNING";
    public static final String UNDERLINE = "_";
    public static final String PID = SystemUtils.IS_OS_WINDOWS ? "handle" : "pid";
    public static final String STAR = "*";
    public static final char N = 'N';
    public static final String GLOBAL_PARAMS = "globalParams";
    public static final String LOCAL_PARAMS = "localParams";
    public static final String SUBPROCESS_INSTANCE_ID = "subProcessInstanceId";
    public static final String PROCESS_INSTANCE_STATE = "processInstanceState";
    public static final String PARENT_WORKFLOW_INSTANCE = "parentWorkflowInstance";
    public static final String CONDITION_RESULT = "conditionResult";
    public static final String SWITCH_RESULT = "switchResult";
    public static final String WAIT_START_TIMEOUT = "waitStartTimeout";
    public static final String DEPENDENCE = "dependence";
    public static final String TASK_LIST = "taskList";
    public static final String QUEUE = "queue";
    public static final String QUEUE_NAME = "queueName";
    public static final int LOG_QUERY_SKIP_LINE_NUMBER = 0;
    public static final int LOG_QUERY_LIMIT = 4096;
    public static final String ALIAS = "alias";
    public static final String CONTENT = "content";
    public static final String DEPENDENT_SPLIT = ":||";
    public static final long DEPENDENT_ALL_TASK_CODE = -1L;
    public static final long DEPENDENT_WORKFLOW_CODE = 0L;
    public static final int PREVIEW_SCHEDULE_EXECUTE_COUNT = 5;
    public static final String KERBEROS = "kerberos";
    public static final String KERBEROS_EXPIRE_TIME = "kerberos.expire.time";
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String JAVA_SECURITY_KRB5_CONF_PATH = "java.security.krb5.conf.path";
    public static final String HADOOP_SECURITY_AUTHENTICATION = "hadoop.security.authentication";
    public static final String HADOOP_SECURITY_AUTHENTICATION_STARTUP_STATE = "hadoop.security.authentication.startup.state";
    public static final String LOGIN_USER_KEY_TAB_USERNAME = "login.user.keytab.username";
    public static final String LOGIN_USER_KEY_TAB_PATH = "login.user.keytab.path";
    public static final String SSO_LOGIN_USER_STATE = "sso.login.user.state";
    public static final String WORKFLOW_INSTANCE_ID_MDC_KEY = "workflowInstanceId";
    public static final String TASK_INSTANCE_ID_MDC_KEY = "taskInstanceId";
    public static final String DOUBLE_BRACKETS_LEFT = "{{";
    public static final String DOUBLE_BRACKETS_RIGHT = "}}";
    public static final String DOUBLE_BRACKETS_LEFT_SPACE = "{ {";
    public static final String DOUBLE_BRACKETS_RIGHT_SPACE = "} }";
    public static final String STATUS = "status";
    public static final String MSG = "msg";
    public static final String COUNT = "count";
    public static final String PAGE_SIZE = "pageSize";
    public static final String PAGE_NUMBER = "pageNo";
    public static final String DATA_LIST = "data";
    public static final String TOTAL_LIST = "totalList";
    public static final String CURRENT_PAGE = "currentPage";
    public static final String TOTAL_PAGE = "totalPage";
    public static final String TOTAL = "total";
    public static final String WORKFLOW_LIST = "workFlowList";
    public static final String WORKFLOW_RELATION_LIST = "workFlowRelationList";
    public static final String SESSION_USER = "session.user";
    public static final String SESSION_ID = "sessionId";
    public static final String LOCALE_LANGUAGE = "language";
    public static final int SESSION_TIME_OUT = 7200;
    public static final int MAX_FILE_SIZE = 0x40000000;
    public static final String UDF = "UDF";
    public static final String CLASS = "class";
    public static final String DEFAULT_WORKER_GROUP = "default";
    public static final int AUTHORIZE_WRITABLE_PERM = 7;
    public static final String START_TIME = "start time";
    public static final String END_TIME = "end time";
    public static final String START_END_DATE = "startDate,endDate";
    public static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String SH = "sh";
    public static final String PSTREE = "pstree";
    public static final int DRY_RUN_FLAG_NO = 0;
    public static final int DRY_RUN_FLAG_YES = 1;
    public static final String DATA_QUALITY_ERROR_OUTPUT_PATH = "data-quality.error.output.path";
    public static final String NAMESPACE = "namespace";
    public static final String CLUSTER = "cluster";
    public static final Long K8S_LOCAL_TEST_CLUSTER_CODE = 0L;
    public static final String SCHEDULE_TIMEZONE = "schedule_timezone";
    public static final int RESOURCE_FULL_NAME_MAX_LENGTH = 128;
    public static final int TENANT_FULL_NAME_MAX_LENGTH = 30;
    public static final int SCHEDULE_TIME_MAX_LENGTH = 100;
    public static final int USER_PASSWORD_MAX_LENGTH = 20;
    public static final int USER_PASSWORD_MIN_LENGTH = 2;
    public static final String FUNCTION_START_WITH = "$";
    public static final Integer DEFAULT_QUEUE_ID = 1;
    public static final String SECURITY_CONFIG_TYPE = "securityConfigType";
    public static final String SECURITY_CONFIG_TYPE_PASSWORD = "PASSWORD";
    public static final String SECURITY_CONFIG_TYPE_LDAP = "LDAP";
    public static final int TEST_FLAG_NO = 0;
    public static final int TEST_FLAG_YES = 1;
    public static final String TYPE_UNIVERSAL = "Universal";
    public static final String TYPE_DATA_INTEGRATION = "DataIntegration";
    public static final String TYPE_CLOUD = "Cloud";
    public static final String TYPE_LOGIC = "Logic";
    public static final String TYPE_DATA_QUALITY = "DataQuality";
    public static final String TYPE_OTHER = "Other";
    public static final String TYPE_MACHINE_LEARNING = "MachineLearning";
    public static final String STRING_PLUGIN_PARAM_FIELD = "field";
    public static final String STRING_PLUGIN_PARAM_NAME = "name";
    public static final String STRING_PLUGIN_PARAM_PROPS = "props";
    public static final String STRING_PLUGIN_PARAM_TYPE = "type";
    public static final String STRING_PLUGIN_PARAM_TITLE = "title";
    public static final String STRING_PLUGIN_PARAM_VALUE = "value";
    public static final String STRING_PLUGIN_PARAM_VALIDATE = "validate";
    public static final String STRING_PLUGIN_PARAM_OPTIONS = "options";
    public static final String STRING_PLUGIN_PARAM_EMIT = "emit";
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    public static final String STRING_YES = "YES";
    public static final String STRING_NO = "NO";
    public static final String SMALL = "small";
    public static final String CHANGE = "change";
    public static final String SUPPORT_HIVE_ONE_SESSION = "support.hive.oneSession";
    public static final Integer QUERY_ALL_ON_SYSTEM = 0;
    public static final Integer QUERY_ALL_ON_PROJECT = 1;
    public static final Integer QUERY_ALL_ON_WORKFLOW = 2;
    public static final Integer QUERY_ALL_ON_TASK = 3;
    public static final String REMOTE_LOGGING_ENABLE = "remote.logging.enable";
    public static final String REMOTE_LOGGING_TARGET = "remote.logging.target";
    public static final String REMOTE_LOGGING_BASE_DIR = "remote.logging.base.dir";
    public static final String REMOTE_LOGGING_THREAD_POOL_SIZE = "remote.logging.thread.pool.size";
    public static final String REMOTE_LOGGING_OSS_ACCESS_KEY_ID = "remote.logging.oss.access.key.id";
    public static final String REMOTE_LOGGING_OSS_ACCESS_KEY_SECRET = "remote.logging.oss.access.key.secret";
    public static final String REMOTE_LOGGING_OSS_BUCKET_NAME = "remote.logging.oss.bucket.name";
    public static final String REMOTE_LOGGING_OSS_ENDPOINT = "remote.logging.oss.endpoint";
    public static final String REMOTE_LOGGING_S3_ACCESS_KEY_ID = "remote.logging.s3.access.key.id";
    public static final String REMOTE_LOGGING_S3_ACCESS_KEY_SECRET = "remote.logging.s3.access.key.secret";
    public static final String REMOTE_LOGGING_S3_BUCKET_NAME = "remote.logging.s3.bucket.name";
    public static final String REMOTE_LOGGING_S3_ENDPOINT = "remote.logging.s3.endpoint";
    public static final String REMOTE_LOGGING_S3_REGION = "remote.logging.s3.region";
    public static final String REMOTE_LOGGING_GCS_CREDENTIAL = "remote.logging.google.cloud.storage.credential";
    public static final String REMOTE_LOGGING_GCS_BUCKET_NAME = "remote.logging.google.cloud.storage.bucket.name";
    public static final String DATABASES_QUERY = "show databases";
    public static final String DATABASES_QUERY_PG = "SELECT datname FROM pg_database";
    public static final String K8S_CONFIG_REGEX = "(?<=((?i)configYaml(\" : \"))).*?(?=(\",\\n))";

    private Constants() {
        throw new UnsupportedOperationException("Construct Constants");
    }
}

