/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import java.util.HashMap;

public enum AuditResourceType {
    USER_MODULE(0, "USER"),
    PROJECT_MODULE(1, "PROJECT");

    private final int code;
    private final String enMsg;
    private static HashMap<Integer, AuditResourceType> AUDIT_RESOURCE_MAP;

    private AuditResourceType(int code, String enMsg) {
        this.code = code;
        this.enMsg = enMsg;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.enMsg;
    }

    public static AuditResourceType of(int status) {
        if (AUDIT_RESOURCE_MAP.containsKey(status)) {
            return AUDIT_RESOURCE_MAP.get(status);
        }
        throw new IllegalArgumentException("invalid audit resource type code " + status);
    }

    static {
        AUDIT_RESOURCE_MAP = new HashMap();
        for (AuditResourceType auditResourceType : AuditResourceType.values()) {
            AUDIT_RESOURCE_MAP.put(auditResourceType.code, auditResourceType);
        }
    }
}

