/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.model;

import lombok.Generated;
import org.apache.dolphinscheduler.common.enums.ServerStatus;
import org.apache.dolphinscheduler.common.model.HeartBeat;

public class MasterHeartBeat
implements HeartBeat {
    private long startupTime;
    private long reportTime;
    private double cpuUsage;
    private double jvmMemoryUsage;
    private double memoryUsage;
    private double diskUsage;
    private ServerStatus serverStatus;
    private int processId;
    private String host;
    private int port;

    @Override
    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    @Generated
    public static MasterHeartBeatBuilder builder() {
        return new MasterHeartBeatBuilder();
    }

    @Generated
    public long getStartupTime() {
        return this.startupTime;
    }

    @Generated
    public long getReportTime() {
        return this.reportTime;
    }

    @Generated
    public double getCpuUsage() {
        return this.cpuUsage;
    }

    @Generated
    public double getJvmMemoryUsage() {
        return this.jvmMemoryUsage;
    }

    @Generated
    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    @Generated
    public double getDiskUsage() {
        return this.diskUsage;
    }

    @Generated
    public int getProcessId() {
        return this.processId;
    }

    @Override
    @Generated
    public String getHost() {
        return this.host;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    @Generated
    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    @Generated
    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    @Generated
    public void setJvmMemoryUsage(double jvmMemoryUsage) {
        this.jvmMemoryUsage = jvmMemoryUsage;
    }

    @Generated
    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    @Generated
    public void setDiskUsage(double diskUsage) {
        this.diskUsage = diskUsage;
    }

    @Generated
    public void setServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Generated
    public void setProcessId(int processId) {
        this.processId = processId;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterHeartBeat)) {
            return false;
        }
        MasterHeartBeat other = (MasterHeartBeat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStartupTime() != other.getStartupTime()) {
            return false;
        }
        if (this.getReportTime() != other.getReportTime()) {
            return false;
        }
        if (Double.compare(this.getCpuUsage(), other.getCpuUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getJvmMemoryUsage(), other.getJvmMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getMemoryUsage(), other.getMemoryUsage()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiskUsage(), other.getDiskUsage()) != 0) {
            return false;
        }
        if (this.getProcessId() != other.getProcessId()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        ServerStatus this$serverStatus = this.getServerStatus();
        ServerStatus other$serverStatus = other.getServerStatus();
        if (this$serverStatus == null ? other$serverStatus != null : !((Object)((Object)this$serverStatus)).equals((Object)other$serverStatus)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MasterHeartBeat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startupTime = this.getStartupTime();
        result = result * 59 + (int)($startupTime >>> 32 ^ $startupTime);
        long $reportTime = this.getReportTime();
        result = result * 59 + (int)($reportTime >>> 32 ^ $reportTime);
        long $cpuUsage = Double.doubleToLongBits(this.getCpuUsage());
        result = result * 59 + (int)($cpuUsage >>> 32 ^ $cpuUsage);
        long $jvmMemoryUsage = Double.doubleToLongBits(this.getJvmMemoryUsage());
        result = result * 59 + (int)($jvmMemoryUsage >>> 32 ^ $jvmMemoryUsage);
        long $memoryUsage = Double.doubleToLongBits(this.getMemoryUsage());
        result = result * 59 + (int)($memoryUsage >>> 32 ^ $memoryUsage);
        long $diskUsage = Double.doubleToLongBits(this.getDiskUsage());
        result = result * 59 + (int)($diskUsage >>> 32 ^ $diskUsage);
        result = result * 59 + this.getProcessId();
        result = result * 59 + this.getPort();
        ServerStatus $serverStatus = this.getServerStatus();
        result = result * 59 + ($serverStatus == null ? 43 : ((Object)((Object)$serverStatus)).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MasterHeartBeat(startupTime=" + this.getStartupTime() + ", reportTime=" + this.getReportTime() + ", cpuUsage=" + this.getCpuUsage() + ", jvmMemoryUsage=" + this.getJvmMemoryUsage() + ", memoryUsage=" + this.getMemoryUsage() + ", diskUsage=" + this.getDiskUsage() + ", serverStatus=" + (Object)((Object)this.getServerStatus()) + ", processId=" + this.getProcessId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    @Generated
    public MasterHeartBeat() {
    }

    @Generated
    public MasterHeartBeat(long startupTime, long reportTime, double cpuUsage, double jvmMemoryUsage, double memoryUsage, double diskUsage, ServerStatus serverStatus, int processId, String host, int port) {
        this.startupTime = startupTime;
        this.reportTime = reportTime;
        this.cpuUsage = cpuUsage;
        this.jvmMemoryUsage = jvmMemoryUsage;
        this.memoryUsage = memoryUsage;
        this.diskUsage = diskUsage;
        this.serverStatus = serverStatus;
        this.processId = processId;
        this.host = host;
        this.port = port;
    }

    @Generated
    public static class MasterHeartBeatBuilder {
        @Generated
        private long startupTime;
        @Generated
        private long reportTime;
        @Generated
        private double cpuUsage;
        @Generated
        private double jvmMemoryUsage;
        @Generated
        private double memoryUsage;
        @Generated
        private double diskUsage;
        @Generated
        private ServerStatus serverStatus;
        @Generated
        private int processId;
        @Generated
        private String host;
        @Generated
        private int port;

        @Generated
        MasterHeartBeatBuilder() {
        }

        @Generated
        public MasterHeartBeatBuilder startupTime(long startupTime) {
            this.startupTime = startupTime;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder reportTime(long reportTime) {
            this.reportTime = reportTime;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder cpuUsage(double cpuUsage) {
            this.cpuUsage = cpuUsage;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder jvmMemoryUsage(double jvmMemoryUsage) {
            this.jvmMemoryUsage = jvmMemoryUsage;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder memoryUsage(double memoryUsage) {
            this.memoryUsage = memoryUsage;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder diskUsage(double diskUsage) {
            this.diskUsage = diskUsage;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder serverStatus(ServerStatus serverStatus) {
            this.serverStatus = serverStatus;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder processId(int processId) {
            this.processId = processId;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public MasterHeartBeatBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public MasterHeartBeat build() {
            return new MasterHeartBeat(this.startupTime, this.reportTime, this.cpuUsage, this.jvmMemoryUsage, this.memoryUsage, this.diskUsage, this.serverStatus, this.processId, this.host, this.port);
        }

        @Generated
        public String toString() {
            return "MasterHeartBeat.MasterHeartBeatBuilder(startupTime=" + this.startupTime + ", reportTime=" + this.reportTime + ", cpuUsage=" + this.cpuUsage + ", jvmMemoryUsage=" + this.jvmMemoryUsage + ", memoryUsage=" + this.memoryUsage + ", diskUsage=" + this.diskUsage + ", serverStatus=" + (Object)((Object)this.serverStatus) + ", processId=" + this.processId + ", host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

