/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.dolphinscheduler.common.utils.JSONUtils;

public class OkHttpUtils {
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).build();

    @NonNull
    public static String get(@NonNull String url, @Nullable Map<String, String> httpHeaders, @Nullable Map<String, Object> requestParams) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String finalUrl = OkHttpUtils.addUrlParams(requestParams, url);
        Request.Builder requestBuilder = new Request.Builder().url(finalUrl);
        OkHttpUtils.addHeader(httpHeaders, requestBuilder);
        Request request = requestBuilder.build();
        try (Response response = CLIENT.newCall(request).execute();){
            String string = OkHttpUtils.getResponseBody(response);
            return string;
        }
    }

    @NonNull
    public static String post(@NonNull String url, @Nullable Map<String, String> httpHeaders, @Nullable Map<String, Object> requestParamsMap, @Nullable Map<String, Object> requestBodyMap) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        String finalUrl = OkHttpUtils.addUrlParams(requestParamsMap, url);
        Request.Builder requestBuilder = new Request.Builder().url(finalUrl);
        OkHttpUtils.addHeader(httpHeaders, requestBuilder);
        if (requestBodyMap != null) {
            requestBuilder = requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)JSONUtils.toJsonString(requestBodyMap)));
        }
        try (Response response = CLIENT.newCall(requestBuilder.build()).execute();){
            String string = OkHttpUtils.getResponseBody(response);
            return string;
        }
    }

    @NonNull
    public static String demoPost(@NonNull String url, @Nullable String token, @Nullable Map<String, Object> requestBodyMap) throws IOException {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (requestBodyMap != null) {
            for (String key : requestBodyMap.keySet()) {
                stringBuffer.append(key + "=" + requestBodyMap.get(key) + "&");
            }
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/x-www-form-urlencoded"), (String)stringBuffer.toString());
        Request request = new Request.Builder().url(url).header("token", token).addHeader("accpect", "application/json").post(body).build();
        try (Response response = CLIENT.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static String addUrlParams(@Nullable Map<String, Object> requestParams, @NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (requestParams == null) {
            return url;
        }
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            throw new IllegalArgumentException(String.format("url: %s is invalid", url));
        }
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        for (Map.Entry<String, Object> entry : requestParams.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue().toString());
        }
        return urlBuilder.toString();
    }

    private static void addHeader(@Nullable Map<String, String> headers, @NonNull Request.Builder requestBuilder) {
        if (requestBuilder == null) {
            throw new NullPointerException("requestBuilder is marked non-null but is null");
        }
        if (headers == null) {
            return;
        }
        headers.forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
    }

    private static String getResponseBody(@NonNull Response response) throws IOException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (response.code() != 200 || response.body() == null) {
            throw new RuntimeException(String.format("Request execute failed, httpCode: %s, httpBody: %s", response.code(), response.body()));
        }
        return response.body().string();
    }
}

