/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.dolphinscheduler.common.config.IPropertyDelegate;
import org.apache.dolphinscheduler.common.config.ImmutablePriorityPropertyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyUtils.class);
    private static final IPropertyDelegate propertyDelegate = new ImmutablePriorityPropertyDelegate("/common.properties");

    public static String getString(String key) {
        return propertyDelegate.get(key.trim());
    }

    public static String getString(String key, String defaultVal) {
        String val = PropertyUtils.getString(key);
        return Strings.isNullOrEmpty((String)val) ? defaultVal : val;
    }

    public static String getUpperCaseString(String key) {
        String val = PropertyUtils.getString(key);
        return Strings.isNullOrEmpty((String)val) ? val : val.toUpperCase();
    }

    public static Integer getInt(String key) {
        return propertyDelegate.getInt(key.trim());
    }

    public static Integer getInt(String key, int defaultValue) {
        return propertyDelegate.getInt(key, defaultValue);
    }

    public static Boolean getBoolean(String key) {
        return propertyDelegate.getBoolean(key);
    }

    public static Boolean getBoolean(String key, Boolean defaultValue) {
        return propertyDelegate.getBoolean(key, defaultValue);
    }

    public static Long getLong(String key) {
        return propertyDelegate.getLong(key);
    }

    public static Long getLong(String key, Long defaultValue) {
        return propertyDelegate.getLong(key, defaultValue);
    }

    public static Double getDouble(String key) {
        return propertyDelegate.getDouble(key);
    }

    public static Double getDouble(String key, Double defaultValue) {
        return propertyDelegate.getDouble(key, defaultValue);
    }

    public static Map<String, String> getByPrefix(String prefix) {
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        for (String propName : propertyDelegate.getPropertyKeys()) {
            if (!propName.startsWith(prefix)) continue;
            matchedProperties.put(propName, propertyDelegate.get(propName));
        }
        return matchedProperties;
    }

    public static <T> Set<T> getSet(String key, Function<String, Set<T>> transformFunction, Set<T> defaultValue) {
        return propertyDelegate.get(key, transformFunction, defaultValue);
    }

    @Generated
    private PropertyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

