/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskDependType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.DagData;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;

@TableName(value="t_ds_process_instance")
public class ProcessInstance {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private Long processDefinitionCode;
    private int processDefinitionVersion;
    private Long projectCode;
    private WorkflowExecutionStatus state;
    private String stateHistory;
    @TableField(exist=false)
    private List<StateDesc> stateDescList;
    private Flag recovery;
    private Date startTime;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private Date endTime;
    private int runTimes;
    private String name;
    private String host;
    @TableField(exist=false)
    private ProcessDefinition processDefinition;
    private CommandType commandType;
    private String commandParam;
    private TaskDependType taskDependType;
    private int maxTryTimes;
    private FailureStrategy failureStrategy;
    private WarningType warningType;
    private Integer warningGroupId;
    private Date scheduleTime;
    private Date commandStartTime;
    private String globalParams;
    @TableField(exist=false)
    private DagData dagData;
    private int executorId;
    private String executorName;
    private String tenantCode;
    @TableField(exist=false)
    private String queue;
    private Flag isSubProcess;
    @TableField(exist=false)
    private String locations;
    private String historyCmd;
    @TableField(exist=false)
    private String dependenceScheduleTimes;
    @TableField(exist=false)
    private String duration;
    private Priority processInstancePriority;
    private String workerGroup;
    private Long environmentCode;
    private int timeout;
    private String varPool;
    private int nextProcessInstanceId;
    private int dryRun;
    private Date restartTime;
    @TableField(exist=false)
    private boolean isBlocked;
    private int testFlag;

    public ProcessInstance(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        this.name = String.join((CharSequence)"-", processDefinition.getName(), String.valueOf(processDefinition.getVersion()), DateUtils.getCurrentTimeStamp());
    }

    public void addHistoryCmd(CommandType cmd) {
        this.historyCmd = !Strings.isNullOrEmpty((String)this.historyCmd) ? String.format("%s,%s", this.historyCmd, cmd.toString()) : cmd.toString();
    }

    public boolean isComplementData() {
        if (Strings.isNullOrEmpty((String)this.historyCmd)) {
            return false;
        }
        return this.historyCmd.startsWith(CommandType.COMPLEMENT_DATA.toString());
    }

    public CommandType getCmdTypeIfComplement() {
        if (this.isComplementData()) {
            return CommandType.COMPLEMENT_DATA;
        }
        return this.commandType;
    }

    public void setStateWithDesc(WorkflowExecutionStatus state, String stateDesc) {
        this.setState(state);
        if (StringUtils.isEmpty((CharSequence)this.getStateHistory())) {
            this.stateDescList = new ArrayList<StateDesc>();
        } else if (this.stateDescList == null) {
            this.stateDescList = JSONUtils.toList((String)this.getStateHistory(), StateDesc.class);
        }
        this.stateDescList.add(new StateDesc(new Date(), state, stateDesc));
        this.setStateHistory(JSONUtils.toJsonString(this.stateDescList));
    }

    @Generated
    public ProcessInstance() {
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public Long getProcessDefinitionCode() {
        return this.processDefinitionCode;
    }

    @Generated
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Generated
    public Long getProjectCode() {
        return this.projectCode;
    }

    @Generated
    public WorkflowExecutionStatus getState() {
        return this.state;
    }

    @Generated
    public String getStateHistory() {
        return this.stateHistory;
    }

    @Generated
    public List<StateDesc> getStateDescList() {
        return this.stateDescList;
    }

    @Generated
    public Flag getRecovery() {
        return this.recovery;
    }

    @Generated
    public Date getStartTime() {
        return this.startTime;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }

    @Generated
    public int getRunTimes() {
        return this.runTimes;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    @Generated
    public CommandType getCommandType() {
        return this.commandType;
    }

    @Generated
    public String getCommandParam() {
        return this.commandParam;
    }

    @Generated
    public TaskDependType getTaskDependType() {
        return this.taskDependType;
    }

    @Generated
    public int getMaxTryTimes() {
        return this.maxTryTimes;
    }

    @Generated
    public FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    @Generated
    public WarningType getWarningType() {
        return this.warningType;
    }

    @Generated
    public Integer getWarningGroupId() {
        return this.warningGroupId;
    }

    @Generated
    public Date getScheduleTime() {
        return this.scheduleTime;
    }

    @Generated
    public Date getCommandStartTime() {
        return this.commandStartTime;
    }

    @Generated
    public String getGlobalParams() {
        return this.globalParams;
    }

    @Generated
    public DagData getDagData() {
        return this.dagData;
    }

    @Generated
    public int getExecutorId() {
        return this.executorId;
    }

    @Generated
    public String getExecutorName() {
        return this.executorName;
    }

    @Generated
    public String getTenantCode() {
        return this.tenantCode;
    }

    @Generated
    public String getQueue() {
        return this.queue;
    }

    @Generated
    public Flag getIsSubProcess() {
        return this.isSubProcess;
    }

    @Generated
    public String getLocations() {
        return this.locations;
    }

    @Generated
    public String getHistoryCmd() {
        return this.historyCmd;
    }

    @Generated
    public String getDependenceScheduleTimes() {
        return this.dependenceScheduleTimes;
    }

    @Generated
    public String getDuration() {
        return this.duration;
    }

    @Generated
    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    @Generated
    public String getWorkerGroup() {
        return this.workerGroup;
    }

    @Generated
    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public String getVarPool() {
        return this.varPool;
    }

    @Generated
    public int getNextProcessInstanceId() {
        return this.nextProcessInstanceId;
    }

    @Generated
    public int getDryRun() {
        return this.dryRun;
    }

    @Generated
    public Date getRestartTime() {
        return this.restartTime;
    }

    @Generated
    public boolean isBlocked() {
        return this.isBlocked;
    }

    @Generated
    public int getTestFlag() {
        return this.testFlag;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setProcessDefinitionCode(Long processDefinitionCode) {
        this.processDefinitionCode = processDefinitionCode;
    }

    @Generated
    public void setProcessDefinitionVersion(int processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    @Generated
    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    @Generated
    public void setState(WorkflowExecutionStatus state) {
        this.state = state;
    }

    @Generated
    public void setStateHistory(String stateHistory) {
        this.stateHistory = stateHistory;
    }

    @Generated
    public void setStateDescList(List<StateDesc> stateDescList) {
        this.stateDescList = stateDescList;
    }

    @Generated
    public void setRecovery(Flag recovery) {
        this.recovery = recovery;
    }

    @Generated
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @Generated
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setRunTimes(int runTimes) {
        this.runTimes = runTimes;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    @Generated
    public void setCommandType(CommandType commandType) {
        this.commandType = commandType;
    }

    @Generated
    public void setCommandParam(String commandParam) {
        this.commandParam = commandParam;
    }

    @Generated
    public void setTaskDependType(TaskDependType taskDependType) {
        this.taskDependType = taskDependType;
    }

    @Generated
    public void setMaxTryTimes(int maxTryTimes) {
        this.maxTryTimes = maxTryTimes;
    }

    @Generated
    public void setFailureStrategy(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    @Generated
    public void setWarningType(WarningType warningType) {
        this.warningType = warningType;
    }

    @Generated
    public void setWarningGroupId(Integer warningGroupId) {
        this.warningGroupId = warningGroupId;
    }

    @Generated
    public void setScheduleTime(Date scheduleTime) {
        this.scheduleTime = scheduleTime;
    }

    @Generated
    public void setCommandStartTime(Date commandStartTime) {
        this.commandStartTime = commandStartTime;
    }

    @Generated
    public void setGlobalParams(String globalParams) {
        this.globalParams = globalParams;
    }

    @Generated
    public void setDagData(DagData dagData) {
        this.dagData = dagData;
    }

    @Generated
    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    @Generated
    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    @Generated
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Generated
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Generated
    public void setIsSubProcess(Flag isSubProcess) {
        this.isSubProcess = isSubProcess;
    }

    @Generated
    public void setLocations(String locations) {
        this.locations = locations;
    }

    @Generated
    public void setHistoryCmd(String historyCmd) {
        this.historyCmd = historyCmd;
    }

    @Generated
    public void setDependenceScheduleTimes(String dependenceScheduleTimes) {
        this.dependenceScheduleTimes = dependenceScheduleTimes;
    }

    @Generated
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Generated
    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    @Generated
    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    @Generated
    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    @Generated
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Generated
    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    @Generated
    public void setNextProcessInstanceId(int nextProcessInstanceId) {
        this.nextProcessInstanceId = nextProcessInstanceId;
    }

    @Generated
    public void setDryRun(int dryRun) {
        this.dryRun = dryRun;
    }

    @Generated
    public void setRestartTime(Date restartTime) {
        this.restartTime = restartTime;
    }

    @Generated
    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    @Generated
    public void setTestFlag(int testFlag) {
        this.testFlag = testFlag;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessInstance)) {
            return false;
        }
        ProcessInstance other = (ProcessInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProcessDefinitionVersion() != other.getProcessDefinitionVersion()) {
            return false;
        }
        if (this.getRunTimes() != other.getRunTimes()) {
            return false;
        }
        if (this.getMaxTryTimes() != other.getMaxTryTimes()) {
            return false;
        }
        if (this.getExecutorId() != other.getExecutorId()) {
            return false;
        }
        if (this.getTimeout() != other.getTimeout()) {
            return false;
        }
        if (this.getNextProcessInstanceId() != other.getNextProcessInstanceId()) {
            return false;
        }
        if (this.getDryRun() != other.getDryRun()) {
            return false;
        }
        if (this.isBlocked() != other.isBlocked()) {
            return false;
        }
        if (this.getTestFlag() != other.getTestFlag()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$processDefinitionCode = this.getProcessDefinitionCode();
        Long other$processDefinitionCode = other.getProcessDefinitionCode();
        if (this$processDefinitionCode == null ? other$processDefinitionCode != null : !((Object)this$processDefinitionCode).equals(other$processDefinitionCode)) {
            return false;
        }
        Long this$projectCode = this.getProjectCode();
        Long other$projectCode = other.getProjectCode();
        if (this$projectCode == null ? other$projectCode != null : !((Object)this$projectCode).equals(other$projectCode)) {
            return false;
        }
        Integer this$warningGroupId = this.getWarningGroupId();
        Integer other$warningGroupId = other.getWarningGroupId();
        if (this$warningGroupId == null ? other$warningGroupId != null : !((Object)this$warningGroupId).equals(other$warningGroupId)) {
            return false;
        }
        Long this$environmentCode = this.getEnvironmentCode();
        Long other$environmentCode = other.getEnvironmentCode();
        if (this$environmentCode == null ? other$environmentCode != null : !((Object)this$environmentCode).equals(other$environmentCode)) {
            return false;
        }
        WorkflowExecutionStatus this$state = this.getState();
        WorkflowExecutionStatus other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$stateHistory = this.getStateHistory();
        String other$stateHistory = other.getStateHistory();
        if (this$stateHistory == null ? other$stateHistory != null : !this$stateHistory.equals(other$stateHistory)) {
            return false;
        }
        List<StateDesc> this$stateDescList = this.getStateDescList();
        List<StateDesc> other$stateDescList = other.getStateDescList();
        if (this$stateDescList == null ? other$stateDescList != null : !((Object)this$stateDescList).equals(other$stateDescList)) {
            return false;
        }
        Flag this$recovery = this.getRecovery();
        Flag other$recovery = other.getRecovery();
        if (this$recovery == null ? other$recovery != null : !this$recovery.equals(other$recovery)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        ProcessDefinition this$processDefinition = this.getProcessDefinition();
        ProcessDefinition other$processDefinition = other.getProcessDefinition();
        if (this$processDefinition == null ? other$processDefinition != null : !((Object)this$processDefinition).equals(other$processDefinition)) {
            return false;
        }
        CommandType this$commandType = this.getCommandType();
        CommandType other$commandType = other.getCommandType();
        if (this$commandType == null ? other$commandType != null : !this$commandType.equals(other$commandType)) {
            return false;
        }
        String this$commandParam = this.getCommandParam();
        String other$commandParam = other.getCommandParam();
        if (this$commandParam == null ? other$commandParam != null : !this$commandParam.equals(other$commandParam)) {
            return false;
        }
        TaskDependType this$taskDependType = this.getTaskDependType();
        TaskDependType other$taskDependType = other.getTaskDependType();
        if (this$taskDependType == null ? other$taskDependType != null : !this$taskDependType.equals(other$taskDependType)) {
            return false;
        }
        FailureStrategy this$failureStrategy = this.getFailureStrategy();
        FailureStrategy other$failureStrategy = other.getFailureStrategy();
        if (this$failureStrategy == null ? other$failureStrategy != null : !this$failureStrategy.equals(other$failureStrategy)) {
            return false;
        }
        WarningType this$warningType = this.getWarningType();
        WarningType other$warningType = other.getWarningType();
        if (this$warningType == null ? other$warningType != null : !this$warningType.equals(other$warningType)) {
            return false;
        }
        Date this$scheduleTime = this.getScheduleTime();
        Date other$scheduleTime = other.getScheduleTime();
        if (this$scheduleTime == null ? other$scheduleTime != null : !((Object)this$scheduleTime).equals(other$scheduleTime)) {
            return false;
        }
        Date this$commandStartTime = this.getCommandStartTime();
        Date other$commandStartTime = other.getCommandStartTime();
        if (this$commandStartTime == null ? other$commandStartTime != null : !((Object)this$commandStartTime).equals(other$commandStartTime)) {
            return false;
        }
        String this$globalParams = this.getGlobalParams();
        String other$globalParams = other.getGlobalParams();
        if (this$globalParams == null ? other$globalParams != null : !this$globalParams.equals(other$globalParams)) {
            return false;
        }
        DagData this$dagData = this.getDagData();
        DagData other$dagData = other.getDagData();
        if (this$dagData == null ? other$dagData != null : !this$dagData.equals(other$dagData)) {
            return false;
        }
        String this$executorName = this.getExecutorName();
        String other$executorName = other.getExecutorName();
        if (this$executorName == null ? other$executorName != null : !this$executorName.equals(other$executorName)) {
            return false;
        }
        String this$tenantCode = this.getTenantCode();
        String other$tenantCode = other.getTenantCode();
        if (this$tenantCode == null ? other$tenantCode != null : !this$tenantCode.equals(other$tenantCode)) {
            return false;
        }
        String this$queue = this.getQueue();
        String other$queue = other.getQueue();
        if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
            return false;
        }
        Flag this$isSubProcess = this.getIsSubProcess();
        Flag other$isSubProcess = other.getIsSubProcess();
        if (this$isSubProcess == null ? other$isSubProcess != null : !this$isSubProcess.equals(other$isSubProcess)) {
            return false;
        }
        String this$locations = this.getLocations();
        String other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !this$locations.equals(other$locations)) {
            return false;
        }
        String this$historyCmd = this.getHistoryCmd();
        String other$historyCmd = other.getHistoryCmd();
        if (this$historyCmd == null ? other$historyCmd != null : !this$historyCmd.equals(other$historyCmd)) {
            return false;
        }
        String this$dependenceScheduleTimes = this.getDependenceScheduleTimes();
        String other$dependenceScheduleTimes = other.getDependenceScheduleTimes();
        if (this$dependenceScheduleTimes == null ? other$dependenceScheduleTimes != null : !this$dependenceScheduleTimes.equals(other$dependenceScheduleTimes)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        Priority this$processInstancePriority = this.getProcessInstancePriority();
        Priority other$processInstancePriority = other.getProcessInstancePriority();
        if (this$processInstancePriority == null ? other$processInstancePriority != null : !this$processInstancePriority.equals(other$processInstancePriority)) {
            return false;
        }
        String this$workerGroup = this.getWorkerGroup();
        String other$workerGroup = other.getWorkerGroup();
        if (this$workerGroup == null ? other$workerGroup != null : !this$workerGroup.equals(other$workerGroup)) {
            return false;
        }
        String this$varPool = this.getVarPool();
        String other$varPool = other.getVarPool();
        if (this$varPool == null ? other$varPool != null : !this$varPool.equals(other$varPool)) {
            return false;
        }
        Date this$restartTime = this.getRestartTime();
        Date other$restartTime = other.getRestartTime();
        return !(this$restartTime == null ? other$restartTime != null : !((Object)this$restartTime).equals(other$restartTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessInstance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProcessDefinitionVersion();
        result = result * 59 + this.getRunTimes();
        result = result * 59 + this.getMaxTryTimes();
        result = result * 59 + this.getExecutorId();
        result = result * 59 + this.getTimeout();
        result = result * 59 + this.getNextProcessInstanceId();
        result = result * 59 + this.getDryRun();
        result = result * 59 + (this.isBlocked() ? 79 : 97);
        result = result * 59 + this.getTestFlag();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $processDefinitionCode = this.getProcessDefinitionCode();
        result = result * 59 + ($processDefinitionCode == null ? 43 : ((Object)$processDefinitionCode).hashCode());
        Long $projectCode = this.getProjectCode();
        result = result * 59 + ($projectCode == null ? 43 : ((Object)$projectCode).hashCode());
        Integer $warningGroupId = this.getWarningGroupId();
        result = result * 59 + ($warningGroupId == null ? 43 : ((Object)$warningGroupId).hashCode());
        Long $environmentCode = this.getEnvironmentCode();
        result = result * 59 + ($environmentCode == null ? 43 : ((Object)$environmentCode).hashCode());
        WorkflowExecutionStatus $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $stateHistory = this.getStateHistory();
        result = result * 59 + ($stateHistory == null ? 43 : $stateHistory.hashCode());
        List<StateDesc> $stateDescList = this.getStateDescList();
        result = result * 59 + ($stateDescList == null ? 43 : ((Object)$stateDescList).hashCode());
        Flag $recovery = this.getRecovery();
        result = result * 59 + ($recovery == null ? 43 : $recovery.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        ProcessDefinition $processDefinition = this.getProcessDefinition();
        result = result * 59 + ($processDefinition == null ? 43 : ((Object)$processDefinition).hashCode());
        CommandType $commandType = this.getCommandType();
        result = result * 59 + ($commandType == null ? 43 : $commandType.hashCode());
        String $commandParam = this.getCommandParam();
        result = result * 59 + ($commandParam == null ? 43 : $commandParam.hashCode());
        TaskDependType $taskDependType = this.getTaskDependType();
        result = result * 59 + ($taskDependType == null ? 43 : $taskDependType.hashCode());
        FailureStrategy $failureStrategy = this.getFailureStrategy();
        result = result * 59 + ($failureStrategy == null ? 43 : $failureStrategy.hashCode());
        WarningType $warningType = this.getWarningType();
        result = result * 59 + ($warningType == null ? 43 : $warningType.hashCode());
        Date $scheduleTime = this.getScheduleTime();
        result = result * 59 + ($scheduleTime == null ? 43 : ((Object)$scheduleTime).hashCode());
        Date $commandStartTime = this.getCommandStartTime();
        result = result * 59 + ($commandStartTime == null ? 43 : ((Object)$commandStartTime).hashCode());
        String $globalParams = this.getGlobalParams();
        result = result * 59 + ($globalParams == null ? 43 : $globalParams.hashCode());
        DagData $dagData = this.getDagData();
        result = result * 59 + ($dagData == null ? 43 : $dagData.hashCode());
        String $executorName = this.getExecutorName();
        result = result * 59 + ($executorName == null ? 43 : $executorName.hashCode());
        String $tenantCode = this.getTenantCode();
        result = result * 59 + ($tenantCode == null ? 43 : $tenantCode.hashCode());
        String $queue = this.getQueue();
        result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
        Flag $isSubProcess = this.getIsSubProcess();
        result = result * 59 + ($isSubProcess == null ? 43 : $isSubProcess.hashCode());
        String $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : $locations.hashCode());
        String $historyCmd = this.getHistoryCmd();
        result = result * 59 + ($historyCmd == null ? 43 : $historyCmd.hashCode());
        String $dependenceScheduleTimes = this.getDependenceScheduleTimes();
        result = result * 59 + ($dependenceScheduleTimes == null ? 43 : $dependenceScheduleTimes.hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        Priority $processInstancePriority = this.getProcessInstancePriority();
        result = result * 59 + ($processInstancePriority == null ? 43 : $processInstancePriority.hashCode());
        String $workerGroup = this.getWorkerGroup();
        result = result * 59 + ($workerGroup == null ? 43 : $workerGroup.hashCode());
        String $varPool = this.getVarPool();
        result = result * 59 + ($varPool == null ? 43 : $varPool.hashCode());
        Date $restartTime = this.getRestartTime();
        result = result * 59 + ($restartTime == null ? 43 : ((Object)$restartTime).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProcessInstance(id=" + this.getId() + ", processDefinitionCode=" + this.getProcessDefinitionCode() + ", processDefinitionVersion=" + this.getProcessDefinitionVersion() + ", projectCode=" + this.getProjectCode() + ", state=" + this.getState() + ", stateHistory=" + this.getStateHistory() + ", stateDescList=" + this.getStateDescList() + ", recovery=" + this.getRecovery() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", runTimes=" + this.getRunTimes() + ", name=" + this.getName() + ", host=" + this.getHost() + ", processDefinition=" + this.getProcessDefinition() + ", commandType=" + this.getCommandType() + ", commandParam=" + this.getCommandParam() + ", taskDependType=" + this.getTaskDependType() + ", maxTryTimes=" + this.getMaxTryTimes() + ", failureStrategy=" + this.getFailureStrategy() + ", warningType=" + this.getWarningType() + ", warningGroupId=" + this.getWarningGroupId() + ", scheduleTime=" + this.getScheduleTime() + ", commandStartTime=" + this.getCommandStartTime() + ", globalParams=" + this.getGlobalParams() + ", dagData=" + this.getDagData() + ", executorId=" + this.getExecutorId() + ", executorName=" + this.getExecutorName() + ", tenantCode=" + this.getTenantCode() + ", queue=" + this.getQueue() + ", isSubProcess=" + this.getIsSubProcess() + ", locations=" + this.getLocations() + ", historyCmd=" + this.getHistoryCmd() + ", dependenceScheduleTimes=" + this.getDependenceScheduleTimes() + ", duration=" + this.getDuration() + ", processInstancePriority=" + this.getProcessInstancePriority() + ", workerGroup=" + this.getWorkerGroup() + ", environmentCode=" + this.getEnvironmentCode() + ", timeout=" + this.getTimeout() + ", varPool=" + this.getVarPool() + ", nextProcessInstanceId=" + this.getNextProcessInstanceId() + ", dryRun=" + this.getDryRun() + ", restartTime=" + this.getRestartTime() + ", isBlocked=" + this.isBlocked() + ", testFlag=" + this.getTestFlag() + ")";
    }

    public static class StateDesc {
        Date time;
        WorkflowExecutionStatus state;
        String desc;

        @Generated
        public Date getTime() {
            return this.time;
        }

        @Generated
        public WorkflowExecutionStatus getState() {
            return this.state;
        }

        @Generated
        public String getDesc() {
            return this.desc;
        }

        @Generated
        public void setTime(Date time) {
            this.time = time;
        }

        @Generated
        public void setState(WorkflowExecutionStatus state) {
            this.state = state;
        }

        @Generated
        public void setDesc(String desc) {
            this.desc = desc;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StateDesc)) {
                return false;
            }
            StateDesc other = (StateDesc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$time = this.getTime();
            Date other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            WorkflowExecutionStatus this$state = this.getState();
            WorkflowExecutionStatus other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$desc = this.getDesc();
            String other$desc = other.getDesc();
            return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StateDesc;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            WorkflowExecutionStatus $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $desc = this.getDesc();
            result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ProcessInstance.StateDesc(time=" + this.getTime() + ", state=" + this.getState() + ", desc=" + this.getDesc() + ")";
        }

        @Generated
        public StateDesc() {
        }

        @Generated
        public StateDesc(Date time, WorkflowExecutionStatus state, String desc) {
            this.time = time;
            this.state = state;
            this.desc = desc;
        }
    }
}

