/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.model.PageListingResult;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.ProcessDefinitionDao;
import org.springframework.stereotype.Repository;

@Repository
public class ProcessDefinitionDaoImpl
extends BaseDao<ProcessDefinition, ProcessDefinitionMapper>
implements ProcessDefinitionDao {
    public ProcessDefinitionDaoImpl(@NonNull ProcessDefinitionMapper processDefinitionMapper) {
        super(processDefinitionMapper);
        if (processDefinitionMapper == null) {
            throw new NullPointerException("processDefinitionMapper is marked non-null but is null");
        }
    }

    @Override
    public PageListingResult<ProcessDefinition> listingProcessDefinition(int pageNumber, int pageSize, String searchVal, int userId, long projectCode) {
        Page page = new Page((long)pageNumber, (long)pageSize);
        IPage<ProcessDefinition> processDefinitions = ((ProcessDefinitionMapper)this.mybatisMapper).queryDefineListPaging((IPage<ProcessDefinition>)page, searchVal, userId, projectCode);
        return PageListingResult.builder().totalCount(processDefinitions.getTotal()).currentPage(pageNumber).pageSize(pageSize).records(processDefinitions.getRecords()).build();
    }

    @Override
    public Optional<ProcessDefinition> queryByCode(long code) {
        return Optional.ofNullable(((ProcessDefinitionMapper)this.mybatisMapper).queryByCode(code));
    }

    @Override
    public void deleteByWorkflowDefinitionCode(long workflowDefinitionCode) {
        ((ProcessDefinitionMapper)this.mybatisMapper).deleteByCode(workflowDefinitionCode);
    }

    @Override
    public List<ProcessDefinition> queryByCodes(Collection<Long> processDefinitionCodes) {
        if (CollectionUtils.isEmpty(processDefinitionCodes)) {
            return Collections.emptyList();
        }
        return ((ProcessDefinitionMapper)this.mybatisMapper).queryByCodes(processDefinitionCodes);
    }
}

