/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.repository.impl;

import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.FailureStrategy;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WorkflowExecutionStatus;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.mapper.ProcessInstanceMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskInstanceMapper;
import org.apache.dolphinscheduler.dao.repository.BaseDao;
import org.apache.dolphinscheduler.dao.repository.TaskInstanceDao;
import org.apache.dolphinscheduler.plugin.task.api.enums.TaskExecutionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TaskInstanceDaoImpl
extends BaseDao<TaskInstance, TaskInstanceMapper>
implements TaskInstanceDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceDaoImpl.class);
    @Autowired
    private ProcessInstanceMapper processInstanceMapper;

    public TaskInstanceDaoImpl(@NonNull TaskInstanceMapper taskInstanceMapper) {
        super(taskInstanceMapper);
        if (taskInstanceMapper == null) {
            throw new NullPointerException("taskInstanceMapper is marked non-null but is null");
        }
    }

    @Override
    public boolean upsertTaskInstance(TaskInstance taskInstance) {
        if (taskInstance.getId() != null) {
            return this.updateById(taskInstance);
        }
        return this.insert(taskInstance) > 0;
    }

    @Override
    public boolean submitTaskInstanceToDB(TaskInstance taskInstance, ProcessInstance processInstance) {
        WorkflowExecutionStatus processInstanceState = processInstance.getState();
        if (processInstanceState.isFinished() || processInstanceState == WorkflowExecutionStatus.READY_STOP) {
            log.warn("processInstance: {} state was: {}, skip submit this task, taskCode: {}", new Object[]{processInstance.getId(), processInstanceState, taskInstance.getTaskCode()});
            return false;
        }
        if (processInstanceState == WorkflowExecutionStatus.READY_PAUSE) {
            taskInstance.setState(TaskExecutionStatus.PAUSE);
        }
        taskInstance.setExecutorId(processInstance.getExecutorId());
        taskInstance.setExecutorName(processInstance.getExecutorName());
        taskInstance.setState(this.getSubmitTaskState(taskInstance, processInstance));
        if (taskInstance.getSubmitTime() == null) {
            taskInstance.setSubmitTime(new Date());
        }
        if (taskInstance.getFirstSubmitTime() == null) {
            taskInstance.setFirstSubmitTime(taskInstance.getSubmitTime());
        }
        return this.upsertTaskInstance(taskInstance);
    }

    private TaskExecutionStatus getSubmitTaskState(TaskInstance taskInstance, ProcessInstance processInstance) {
        TaskExecutionStatus state = taskInstance.getState();
        if (state == TaskExecutionStatus.RUNNING_EXECUTION || state == TaskExecutionStatus.DELAY_EXECUTION || state == TaskExecutionStatus.KILL || state == TaskExecutionStatus.DISPATCH) {
            return state;
        }
        state = processInstance.getState() == WorkflowExecutionStatus.READY_PAUSE ? TaskExecutionStatus.PAUSE : (processInstance.getState() == WorkflowExecutionStatus.READY_STOP || !this.checkProcessStrategy(taskInstance, processInstance) ? TaskExecutionStatus.KILL : TaskExecutionStatus.SUBMITTED_SUCCESS);
        return state;
    }

    private boolean checkProcessStrategy(TaskInstance taskInstance, ProcessInstance processInstance) {
        FailureStrategy failureStrategy = processInstance.getFailureStrategy();
        if (failureStrategy == FailureStrategy.CONTINUE) {
            return true;
        }
        List<TaskInstance> taskInstances = this.queryValidTaskListByWorkflowInstanceId(taskInstance.getProcessInstanceId(), taskInstance.getTestFlag());
        for (TaskInstance task : taskInstances) {
            if (task.getState() != TaskExecutionStatus.FAILURE || task.getRetryTimes() < task.getMaxRetryTimes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<TaskInstance> queryValidTaskListByWorkflowInstanceId(Integer processInstanceId, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findValidTaskListByProcessId(processInstanceId, Flag.YES, testFlag);
    }

    @Override
    public TaskInstance queryByWorkflowInstanceIdAndTaskCode(Integer processInstanceId, Long taskCode) {
        return ((TaskInstanceMapper)this.mybatisMapper).queryByInstanceIdAndCode(processInstanceId, taskCode);
    }

    @Override
    public List<TaskInstance> queryPreviousTaskListByWorkflowInstanceId(Integer processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processInstanceMapper.selectById(processInstanceId);
        return ((TaskInstanceMapper)this.mybatisMapper).findValidTaskListByProcessId(processInstanceId, Flag.NO, processInstance.getTestFlag());
    }

    @Override
    public TaskInstance queryByCacheKey(String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return null;
        }
        return ((TaskInstanceMapper)this.mybatisMapper).queryByCacheKey(cacheKey);
    }

    @Override
    public Boolean clearCacheByCacheKey(String cacheKey) {
        try {
            ((TaskInstanceMapper)this.mybatisMapper).clearCacheByCacheKey(cacheKey);
            return true;
        }
        catch (Exception e) {
            log.error("clear cache by cacheKey failed", (Throwable)e);
            return false;
        }
    }

    @Override
    public void deleteByWorkflowInstanceId(int workflowInstanceId) {
        ((TaskInstanceMapper)this.mybatisMapper).deleteByWorkflowInstanceId(workflowInstanceId);
    }

    @Override
    public List<TaskInstance> queryByWorkflowInstanceId(Integer workflowInstanceId) {
        return ((TaskInstanceMapper)this.mybatisMapper).findByWorkflowInstanceId(workflowInstanceId);
    }

    @Override
    public List<TaskInstance> queryLastTaskInstanceListIntervalInProcessInstance(Integer processInstanceId, Set<Long> taskCodes, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findLastTaskInstances(processInstanceId, taskCodes, testFlag);
    }

    @Override
    public TaskInstance queryLastTaskInstanceIntervalInProcessInstance(Integer processInstanceId, long depTaskCode, int testFlag) {
        return ((TaskInstanceMapper)this.mybatisMapper).findLastTaskInstance(processInstanceId, depTaskCode, testFlag);
    }
}

