/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.dameng.param;

import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.dameng.param.DamengConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.dameng.param.DamengDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

@AutoService(value={DataSourceProcessor.class})
public class DamengDataSourceProcessor
extends AbstractDataSourceProcessor {
    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, DamengDataSourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        DamengConnectionParam connectionParams = (DamengConnectionParam)this.createConnectionParams(connectionJson);
        DamengDataSourceParamDTO damengDatasourceParamDTO = new DamengDataSourceParamDTO();
        damengDatasourceParamDTO.setUserName(connectionParams.getUser());
        damengDatasourceParamDTO.setDatabase(connectionParams.getDatabase());
        damengDatasourceParamDTO.setOther(connectionParams.getOther());
        String address = connectionParams.getAddress();
        String[] hostSeperator = address.split("//");
        String[] hostPortArray = hostSeperator[hostSeperator.length - 1].split(",");
        damengDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        damengDatasourceParamDTO.setHost(hostPortArray[0].split(":")[0]);
        return damengDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO dataSourceParam) {
        DamengDataSourceParamDTO dmDatasourceParam = (DamengDataSourceParamDTO)dataSourceParam;
        String address = String.format("%s%s:%s", "jdbc:dm://", dmDatasourceParam.getHost(), dmDatasourceParam.getPort());
        String jdbcUrl = StringUtils.isEmpty((CharSequence)dmDatasourceParam.getDatabase()) ? address : String.format("%s/%s", address, dmDatasourceParam.getDatabase());
        DamengConnectionParam damengConnectionParam = new DamengConnectionParam();
        damengConnectionParam.setJdbcUrl(jdbcUrl);
        damengConnectionParam.setDatabase(damengConnectionParam.getDatabase());
        damengConnectionParam.setAddress(address);
        damengConnectionParam.setUser(dmDatasourceParam.getUserName());
        damengConnectionParam.setPassword(PasswordUtils.encodePassword((String)dmDatasourceParam.getPassword()));
        damengConnectionParam.setDriverClassName(this.getDatasourceDriver());
        damengConnectionParam.setValidationQuery(this.getValidationQuery());
        damengConnectionParam.setOther(dmDatasourceParam.getOther());
        return damengConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, DamengConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "dm.jdbc.driver.DmDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        DamengConnectionParam damengConnectionParam = (DamengConnectionParam)connectionParam;
        String jdbcUrl = damengConnectionParam.getJdbcUrl();
        if (MapUtils.isNotEmpty((Map)damengConnectionParam.getOther())) {
            return String.format("%s?%s", jdbcUrl, this.transformOther(damengConnectionParam.getOther()));
        }
        return jdbcUrl;
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        DamengConnectionParam damengConnectionParam = (DamengConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl((ConnectionParam)damengConnectionParam), damengConnectionParam.getUser(), PasswordUtils.decodePassword((String)damengConnectionParam.getPassword()));
    }

    public DbType getDbType() {
        return DbType.DAMENG;
    }

    public DataSourceProcessor create() {
        return new DamengDataSourceProcessor();
    }

    public List<String> splitAndRemoveComment(String sql) {
        return SQLParserUtils.splitAndRemoveComment((String)sql, (com.alibaba.druid.DbType)com.alibaba.druid.DbType.dm);
    }

    private String transformOther(Map<String, String> paramMap) {
        if (MapUtils.isEmpty(paramMap)) {
            return null;
        }
        ArrayList otherList = new ArrayList();
        paramMap.forEach((key, value) -> otherList.add(String.format("%s=%s", key, value)));
        return String.join((CharSequence)"&", otherList);
    }
}

