/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.sagemaker.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.sagemaker.SagemakerClientWrapper;
import org.apache.dolphinscheduler.plugin.datasource.sagemaker.param.SagemakerConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.sagemaker.param.SagemakerDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class SagemakerDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SagemakerDataSourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, SagemakerDataSourceParamDTO.class);
    }

    public void checkDatasourceParam(BaseDataSourceParamDTO datasourceParamDTO) {
        SagemakerDataSourceParamDTO sageMakerDataSourceParamDTO = (SagemakerDataSourceParamDTO)datasourceParamDTO;
        if (StringUtils.isEmpty((CharSequence)sageMakerDataSourceParamDTO.getUserName()) || StringUtils.isEmpty((CharSequence)sageMakerDataSourceParamDTO.getPassword()) || StringUtils.isEmpty((CharSequence)sageMakerDataSourceParamDTO.getAwsRegion())) {
            throw new IllegalArgumentException("sagemaker datasource param is not valid");
        }
    }

    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        SagemakerConnectionParam baseConnectionParam = (SagemakerConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}@{3}", dbType.getDescp(), PasswordUtils.encodePassword((String)baseConnectionParam.getUserName()), PasswordUtils.encodePassword((String)baseConnectionParam.getPassword()), PasswordUtils.encodePassword((String)baseConnectionParam.getAwsRegion()));
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        SagemakerConnectionParam connectionParams = (SagemakerConnectionParam)this.createConnectionParams(connectionJson);
        SagemakerDataSourceParamDTO sagemakerDataSourceParamDTO = new SagemakerDataSourceParamDTO();
        sagemakerDataSourceParamDTO.setUserName(connectionParams.getUserName());
        sagemakerDataSourceParamDTO.setPassword(connectionParams.getPassword());
        sagemakerDataSourceParamDTO.setAwsRegion(connectionParams.getAwsRegion());
        return sagemakerDataSourceParamDTO;
    }

    public SagemakerConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        SagemakerDataSourceParamDTO sageMakerDataSourceParam = (SagemakerDataSourceParamDTO)datasourceParam;
        SagemakerConnectionParam sageMakerConnectionParam = new SagemakerConnectionParam();
        sageMakerConnectionParam.setUserName(sageMakerDataSourceParam.getUserName());
        sageMakerConnectionParam.setPassword(sageMakerDataSourceParam.getPassword());
        sageMakerConnectionParam.setAwsRegion(sageMakerDataSourceParam.getAwsRegion());
        return sageMakerConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, SagemakerConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "";
    }

    public String getValidationQuery() {
        return "";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        return "";
    }

    public Connection getConnection(ConnectionParam connectionParam) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        SagemakerConnectionParam baseConnectionParam = (SagemakerConnectionParam)connectionParam;
        try (SagemakerClientWrapper sagemakerClientWrapper = new SagemakerClientWrapper(baseConnectionParam.userName, baseConnectionParam.password, baseConnectionParam.awsRegion);){
            boolean bl = sagemakerClientWrapper.checkConnect();
            return bl;
        }
        catch (Exception e) {
            log.error("sagemaker client failed to connect to the server", (Throwable)e);
            return false;
        }
    }

    public DbType getDbType() {
        return DbType.SAGEMAKER;
    }

    public DataSourceProcessor create() {
        return new SagemakerDataSourceProcessor();
    }
}

