/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.snowflake.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.snowflake.param.SnowflakeConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.snowflake.param.SnowflakeDatasourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class SnowflakeDatasourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnowflakeDatasourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, SnowflakeDatasourceParamDTO.class);
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        String[] hostPortArray;
        SnowflakeConnectionParam snowFlakeConnectionParam = (SnowflakeConnectionParam)this.createConnectionParams(connectionJson);
        String[] tmpArray = snowFlakeConnectionParam.getAddress().split("//");
        StringBuilder hosts = new StringBuilder();
        for (String hostPort : hostPortArray = tmpArray[tmpArray.length - 1].split(",")) {
            hosts.append(hostPort.split(":")[0]).append(",");
        }
        hosts.deleteCharAt(hosts.length() - 1);
        SnowflakeDatasourceParamDTO snowflakeDatasourceParamDTO = new SnowflakeDatasourceParamDTO();
        snowflakeDatasourceParamDTO.setPort(Integer.parseInt(hostPortArray[0].split(":")[1]));
        snowflakeDatasourceParamDTO.setHost(hosts.toString());
        snowflakeDatasourceParamDTO.setDatabase(snowFlakeConnectionParam.getDatabase());
        snowflakeDatasourceParamDTO.setUserName(snowFlakeConnectionParam.getUser());
        snowflakeDatasourceParamDTO.setOther(snowFlakeConnectionParam.getOther());
        return snowflakeDatasourceParamDTO;
    }

    public BaseConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        SnowflakeDatasourceParamDTO snowflakeParam = (SnowflakeDatasourceParamDTO)datasourceParam;
        StringBuilder address = new StringBuilder();
        address.append("jdbc:snowflake://");
        for (String zkHost : datasourceParam.getHost().split(",")) {
            address.append(String.format("%s:%s,", zkHost, datasourceParam.getPort()));
        }
        address.deleteCharAt(address.length() - 1);
        String jdbcUrl = address.toString() + "/" + datasourceParam.getDatabase();
        SnowflakeConnectionParam snowFlakeConnectionParam = new SnowflakeConnectionParam();
        snowFlakeConnectionParam.setUser(snowflakeParam.getUserName());
        snowFlakeConnectionParam.setPassword(PasswordUtils.encodePassword((String)snowflakeParam.getPassword()));
        snowFlakeConnectionParam.setOther(snowflakeParam.getOther());
        snowFlakeConnectionParam.setAddress(address.toString());
        snowFlakeConnectionParam.setJdbcUrl(jdbcUrl);
        snowFlakeConnectionParam.setDriverClassName(this.getDatasourceDriver());
        snowFlakeConnectionParam.setValidationQuery(this.getValidationQuery());
        return snowFlakeConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, SnowflakeConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "net.snowflake.client.jdbc.SnowflakeDriver";
    }

    public String getValidationQuery() {
        return "select 1";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        SnowflakeConnectionParam snowFlakeConnectionParam = (SnowflakeConnectionParam)connectionParam;
        if (MapUtils.isNotEmpty((Map)snowFlakeConnectionParam.getOther())) {
            return String.format("%s?%s", snowFlakeConnectionParam.getJdbcUrl(), snowFlakeConnectionParam.getOther());
        }
        return snowFlakeConnectionParam.getJdbcUrl();
    }

    public Connection getConnection(ConnectionParam connectionParam) throws ClassNotFoundException, SQLException {
        SnowflakeConnectionParam snowFlakeConnectionParam = (SnowflakeConnectionParam)connectionParam;
        Class.forName(this.getDatasourceDriver());
        return DriverManager.getConnection(this.getJdbcUrl(connectionParam), snowFlakeConnectionParam.getUser(), PasswordUtils.decodePassword((String)snowFlakeConnectionParam.getPassword()));
    }

    public DataSourceProcessor create() {
        return new SnowflakeDatasourceProcessor();
    }

    public DbType getDbType() {
        return DbType.SNOWFLAKE;
    }
}

