/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.zeppelin.param;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.text.MessageFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.AbstractDataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.plugin.datasource.api.datasource.DataSourceProcessor;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.datasource.zeppelin.ZeppelinClientWrapper;
import org.apache.dolphinscheduler.plugin.datasource.zeppelin.param.ZeppelinConnectionParam;
import org.apache.dolphinscheduler.plugin.datasource.zeppelin.param.ZeppelinDataSourceParamDTO;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceProcessor.class})
public class ZeppelinDataSourceProcessor
extends AbstractDataSourceProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZeppelinDataSourceProcessor.class);

    public BaseDataSourceParamDTO castDatasourceParamDTO(String paramJson) {
        return (BaseDataSourceParamDTO)JSONUtils.parseObject((String)paramJson, ZeppelinDataSourceParamDTO.class);
    }

    public void checkDatasourceParam(BaseDataSourceParamDTO datasourceParamDTO) {
        ZeppelinDataSourceParamDTO zeppelinDataSourceParamDTO = (ZeppelinDataSourceParamDTO)datasourceParamDTO;
        if (StringUtils.isEmpty((CharSequence)zeppelinDataSourceParamDTO.getRestEndpoint()) || StringUtils.isEmpty((CharSequence)zeppelinDataSourceParamDTO.getUserName())) {
            throw new IllegalArgumentException("zeppelin datasource param is not valid");
        }
    }

    public String getDatasourceUniqueId(ConnectionParam connectionParam, DbType dbType) {
        ZeppelinConnectionParam baseConnectionParam = (ZeppelinConnectionParam)connectionParam;
        return MessageFormat.format("{0}@{1}@{2}@{3}", dbType.getDescp(), baseConnectionParam.getRestEndpoint(), baseConnectionParam.getUsername(), PasswordUtils.encodePassword((String)baseConnectionParam.getPassword()));
    }

    public BaseDataSourceParamDTO createDatasourceParamDTO(String connectionJson) {
        ZeppelinConnectionParam connectionParams = (ZeppelinConnectionParam)this.createConnectionParams(connectionJson);
        ZeppelinDataSourceParamDTO zeppelinDataSourceParamDTO = new ZeppelinDataSourceParamDTO();
        zeppelinDataSourceParamDTO.setUserName(connectionParams.getUsername());
        zeppelinDataSourceParamDTO.setPassword(connectionParams.getPassword());
        zeppelinDataSourceParamDTO.setRestEndpoint(connectionParams.getRestEndpoint());
        return zeppelinDataSourceParamDTO;
    }

    public ZeppelinConnectionParam createConnectionParams(BaseDataSourceParamDTO datasourceParam) {
        ZeppelinDataSourceParamDTO zeppelinDataSourceParam = (ZeppelinDataSourceParamDTO)datasourceParam;
        ZeppelinConnectionParam zeppelinConnectionParam = new ZeppelinConnectionParam();
        zeppelinConnectionParam.setUsername(zeppelinDataSourceParam.getUserName());
        zeppelinConnectionParam.setPassword(zeppelinDataSourceParam.getPassword());
        zeppelinConnectionParam.setRestEndpoint(zeppelinDataSourceParam.getRestEndpoint());
        return zeppelinConnectionParam;
    }

    public ConnectionParam createConnectionParams(String connectionJson) {
        return (ConnectionParam)JSONUtils.parseObject((String)connectionJson, ZeppelinConnectionParam.class);
    }

    public String getDatasourceDriver() {
        return "";
    }

    public String getValidationQuery() {
        return "";
    }

    public String getJdbcUrl(ConnectionParam connectionParam) {
        return "";
    }

    public Connection getConnection(ConnectionParam connectionParam) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDataSourceConnectivity(ConnectionParam connectionParam) {
        ZeppelinConnectionParam baseConnectionParam = (ZeppelinConnectionParam)connectionParam;
        try (ZeppelinClientWrapper zeppelinClientWrapper = new ZeppelinClientWrapper(baseConnectionParam.getRestEndpoint());){
            boolean bl = zeppelinClientWrapper.checkConnect(baseConnectionParam.username, baseConnectionParam.password);
            return bl;
        }
        catch (Exception e) {
            log.error("zeppelin client failed to connect to the server", (Throwable)e);
            return false;
        }
    }

    public DbType getDbType() {
        return DbType.ZEPPELIN;
    }

    public DataSourceProcessor create() {
        return new ZeppelinDataSourceProcessor();
    }
}

