/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate-dolphin-service-descriptor", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class DolphinDescriptorGenerator
extends AbstractMojo {
    private static final String LS_ALIAS = System.getProperty("line.separator");
    @Parameter(defaultValue="org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin")
    private String pluginClassName;
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/services")
    private File servicesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        List<Class<?>> pluginImplClasses;
        File spiServicesFile = new File(this.servicesDirectory, this.pluginClassName);
        if (spiServicesFile.exists()) {
            return;
        }
        if (!spiServicesFile.getParentFile().exists()) {
            File file = spiServicesFile.getParentFile();
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new MojoExecutionException(String.format("%n%nFailed to create directory: %s", file));
            }
        }
        try {
            URLClassLoader loader = this.createCLFromCompileTimeDependencies();
            pluginImplClasses = this.findPluginImplClasses(loader);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("%n%nError for find the classes that implements %s.", this.pluginClassName), e);
        }
        if (pluginImplClasses.isEmpty()) {
            throw new MojoExecutionException(String.format("%n%nNot find classes implements %s, You must have at least one class that implements %s.", this.pluginClassName, this.pluginClassName));
        }
        if (pluginImplClasses.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> pluginClass : pluginImplClasses) {
                sb.append(pluginClass.getName()).append(LS_ALIAS);
            }
            throw new MojoExecutionException(String.format("%n%nFound more than one class that implements %s:%n%n%s%nYou can only have one per plugin project.", this.pluginClassName, sb));
        }
        try {
            Class<?> pluginClass = pluginImplClasses.get(0);
            Files.write(spiServicesFile.toPath(), pluginClass.getName().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.getLog().info((CharSequence)String.format("Wrote %s to %s", pluginClass.getName(), spiServicesFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write services JAR file.", (Exception)e);
        }
    }

    private URLClassLoader createCLFromCompileTimeDependencies() throws Exception {
        ArrayList<URL> classesUrls = new ArrayList<URL>();
        classesUrls.add(this.classesDirectory.toURI().toURL());
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            classesUrls.add(artifact.getFile().toURI().toURL());
        }
        return new URLClassLoader(classesUrls.toArray(new URL[0]));
    }

    private List<Class<?>> findPluginImplClasses(URLClassLoader urlClassLoader) throws IOException, MojoExecutionException {
        ArrayList implementations = new ArrayList();
        List classes = FileUtils.getFileNames((File)this.classesDirectory, (String)"**/*.class", null, (boolean)false);
        for (String classPath : classes) {
            String className = classPath.substring(0, classPath.length() - 6).replace(File.separatorChar, '.');
            try {
                Class<?> pluginClass = urlClassLoader.loadClass(this.pluginClassName);
                Class<?> clazz = urlClassLoader.loadClass(className);
                if (!DolphinDescriptorGenerator.isImplementation(clazz, pluginClass)) continue;
                implementations.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Failed to load class.", (Exception)e);
            }
        }
        return implementations;
    }

    private static boolean isImplementation(Class<?> clazz, Class<?> pluginClass) {
        return pluginClass.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers()) && !Modifier.isInterface(clazz.getModifiers());
    }
}

