/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator;

import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopJobType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.CommonGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ITargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.HanaSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.HdfsSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.HiveSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.MySQLSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.OracleSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources.SqlServerSourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.HanaTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.HdfsTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.HiveTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.MySQLTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.OracleTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.targets.SqlServerTargetGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;

public class SqoopJobGenerator {
    private ITargetGenerator targetGenerator;
    private ISourceGenerator sourceGenerator;
    private final CommonGenerator commonGenerator = new CommonGenerator();

    private void createSqoopJobGenerator(String sourceType, String targetType) {
        this.sourceGenerator = this.createSourceGenerator(sourceType);
        this.targetGenerator = this.createTargetGenerator(targetType);
    }

    public String generateSqoopJob(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        String sqoopScripts = "";
        if (SqoopJobType.TEMPLATE.getDescp().equals(sqoopParameters.getJobType())) {
            this.createSqoopJobGenerator(sqoopParameters.getSourceType(), sqoopParameters.getTargetType());
            if (this.sourceGenerator == null || this.targetGenerator == null) {
                throw new RuntimeException("sqoop task source type or target type is null");
            }
            sqoopScripts = String.format("%s%s%s", this.commonGenerator.generate(sqoopParameters), this.sourceGenerator.generate(sqoopParameters, sqoopTaskExecutionContext), this.targetGenerator.generate(sqoopParameters, sqoopTaskExecutionContext));
        } else if (SqoopJobType.CUSTOM.getDescp().equals(sqoopParameters.getJobType())) {
            sqoopScripts = sqoopParameters.getCustomShell().replaceAll("\\r\\n", System.lineSeparator());
        }
        return sqoopScripts;
    }

    private ISourceGenerator createSourceGenerator(String sourceType) {
        switch (sourceType) {
            case "MYSQL": {
                return new MySQLSourceGenerator();
            }
            case "HIVE": {
                return new HiveSourceGenerator();
            }
            case "HDFS": {
                return new HdfsSourceGenerator();
            }
            case "ORACLE": {
                return new OracleSourceGenerator();
            }
            case "HANA": {
                return new HanaSourceGenerator();
            }
            case "SQLSERVER": {
                return new SqlServerSourceGenerator();
            }
        }
        return null;
    }

    private ITargetGenerator createTargetGenerator(String targetType) {
        switch (targetType) {
            case "MYSQL": {
                return new MySQLTargetGenerator();
            }
            case "HIVE": {
                return new HiveTargetGenerator();
            }
            case "HDFS": {
                return new HdfsTargetGenerator();
            }
            case "ORACLE": {
                return new OracleTargetGenerator();
            }
            case "HANA": {
                return new HanaTargetGenerator();
            }
            case "SQLSERVER": {
                return new SqlServerTargetGenerator();
            }
        }
        return null;
    }
}

