/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopQueryType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceHanaParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HanaSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder hanaSourceSb = new StringBuilder();
        try {
            SourceHanaParameter sourceHanaParameter = (SourceHanaParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHanaParameter.class);
            if (null == sourceHanaParameter) {
                return hanaSourceSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getSourcetype(), (String)sqoopTaskExecutionContext.getSourceConnectionParams());
            if (null == baseDataSource) {
                return hanaSourceSb.toString();
            }
            hanaSourceSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.HANA, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--driver").append(" ").append(DataSourceUtils.getDatasourceDriver((DbType)DbType.HANA)).append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"");
            if (sourceHanaParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                if (StringUtils.isNotEmpty((CharSequence)sourceHanaParameter.getSrcTable())) {
                    hanaSourceSb.append(" ").append("--table").append(" ").append(sourceHanaParameter.getSrcTable());
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceHanaParameter.getSrcColumns())) {
                    hanaSourceSb.append(" ").append("--columns").append(" ").append(sourceHanaParameter.getSrcColumns());
                }
            } else if (sourceHanaParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceHanaParameter.getSrcQuerySql())) {
                String srcQuery = sourceHanaParameter.getSrcQuerySql();
                hanaSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                if (srcQuery.toLowerCase().contains("where")) {
                    hanaSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                } else {
                    hanaSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                }
            }
            HanaSourceGenerator.buildColumnMapToHIve(hanaSourceSb, sourceHanaParameter);
            HanaSourceGenerator.buildColumnMapToJava(hanaSourceSb, sourceHanaParameter);
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task hana source params build failed: [%s]", e.getMessage()));
        }
        return hanaSourceSb.toString();
    }

    private static void buildColumnMapToJava(StringBuilder hanaSourceSb, SourceHanaParameter sourceHanaParameter) {
        List<Property> mapColumnJava = sourceHanaParameter.getMapColumnJava();
        if (null != mapColumnJava && !mapColumnJava.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnJava) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                hanaSourceSb.append(" ").append("--map-column-java").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }

    private static void buildColumnMapToHIve(StringBuilder hanaSourceSb, SourceHanaParameter sourceHanaParameter) {
        List<Property> mapColumnHive = sourceHanaParameter.getMapColumnHive();
        if (null != mapColumnHive && !mapColumnHive.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnHive) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                hanaSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }
}

