/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceHdfsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSourceGenerator
implements ISourceGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HdfsSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder hdfsSourceSb;
        block3: {
            hdfsSourceSb = new StringBuilder();
            try {
                SourceHdfsParameter sourceHdfsParameter = (SourceHdfsParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceHdfsParameter.class);
                if (null == sourceHdfsParameter) break block3;
                if (StringUtils.isNotEmpty((CharSequence)sourceHdfsParameter.getExportDir())) {
                    hdfsSourceSb.append(" ").append("--export-dir").append(" ").append(sourceHdfsParameter.getExportDir());
                    break block3;
                }
                throw new IllegalArgumentException("Sqoop hdfs export dir is null");
            }
            catch (Exception e) {
                log.error(String.format("Sqoop hdfs source parmas build failed: [%s]", e.getMessage()));
            }
        }
        return hdfsSourceSb.toString();
    }
}

