/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop.generator.sources;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.PasswordUtils;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopQueryType;
import org.apache.dolphinscheduler.plugin.task.sqoop.SqoopTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.ISourceGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.sources.SourceOracleParameter;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSourceGenerator
implements ISourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(OracleSourceGenerator.class);

    @Override
    public String generate(SqoopParameters sqoopParameters, SqoopTaskExecutionContext sqoopTaskExecutionContext) {
        StringBuilder oracleSourceSb = new StringBuilder();
        try {
            SourceOracleParameter sourceOracleParameter = (SourceOracleParameter)JSONUtils.parseObject((String)sqoopParameters.getSourceParams(), SourceOracleParameter.class);
            if (null == sourceOracleParameter) {
                return oracleSourceSb.toString();
            }
            BaseConnectionParam baseDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)sqoopTaskExecutionContext.getSourcetype(), (String)sqoopTaskExecutionContext.getSourceConnectionParams());
            if (null == baseDataSource) {
                return oracleSourceSb.toString();
            }
            oracleSourceSb.append(" ").append("--connect").append(" ").append("\"").append(DataSourceUtils.getJdbcUrl((DbType)DbType.ORACLE, (ConnectionParam)baseDataSource)).append("\"").append(" ").append("--username").append(" ").append(baseDataSource.getUser()).append(" ").append("--password").append(" ").append("\"").append(PasswordUtils.decodePassword((String)baseDataSource.getPassword())).append("\"");
            if (sourceOracleParameter.getSrcQueryType() == SqoopQueryType.FORM.getCode().intValue()) {
                if (StringUtils.isNotEmpty((CharSequence)sourceOracleParameter.getSrcTable())) {
                    oracleSourceSb.append(" ").append("--table").append(" ").append(sourceOracleParameter.getSrcTable());
                }
                if (StringUtils.isNotEmpty((CharSequence)sourceOracleParameter.getSrcColumns())) {
                    oracleSourceSb.append(" ").append("--columns").append(" ").append(sourceOracleParameter.getSrcColumns());
                }
            } else if (sourceOracleParameter.getSrcQueryType() == SqoopQueryType.SQL.getCode().intValue() && StringUtils.isNotEmpty((CharSequence)sourceOracleParameter.getSrcQuerySql())) {
                String srcQuery = sourceOracleParameter.getSrcQuerySql();
                oracleSourceSb.append(" ").append("--query").append(" ").append("\"").append(srcQuery);
                if (srcQuery.toLowerCase().contains("where")) {
                    oracleSourceSb.append(" ").append("AND \\$CONDITIONS").append("\"");
                } else {
                    oracleSourceSb.append(" ").append("WHERE \\$CONDITIONS").append("\"");
                }
            }
            OracleSourceGenerator.buildColumnMapToHIve(oracleSourceSb, sourceOracleParameter);
            OracleSourceGenerator.buildColumnMapToJava(oracleSourceSb, sourceOracleParameter);
        }
        catch (Exception e) {
            logger.error(String.format("Sqoop task oracle source params build failed: [%s]", e.getMessage()));
        }
        return oracleSourceSb.toString();
    }

    private static void buildColumnMapToJava(StringBuilder oracleSourceSb, SourceOracleParameter sourceOracleParameter) {
        List<Property> mapColumnJava = sourceOracleParameter.getMapColumnJava();
        if (null != mapColumnJava && !mapColumnJava.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnJava) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                oracleSourceSb.append(" ").append("--map-column-java").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }

    private static void buildColumnMapToHIve(StringBuilder oracleSourceSb, SourceOracleParameter sourceOracleParameter) {
        List<Property> mapColumnHive = sourceOracleParameter.getMapColumnHive();
        if (null != mapColumnHive && !mapColumnHive.isEmpty()) {
            StringBuilder columnMap = new StringBuilder();
            for (Property item : mapColumnHive) {
                columnMap.append(item.getProp()).append("=").append(item.getValue()).append(",");
            }
            if (StringUtils.isNotEmpty((CharSequence)columnMap.toString())) {
                oracleSourceSb.append(" ").append("--map-column-hive").append(" ").append(columnMap.substring(0, columnMap.length() - 1));
            }
        }
    }
}

