/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application.executors;

import java.util.Collection;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.application.executors.EmbeddedExecutorFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.core.execution.PipelineExecutorServiceLoader;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.util.Preconditions;

@Internal
public class EmbeddedExecutorServiceLoader
implements PipelineExecutorServiceLoader {
    private final Collection<JobID> submittedJobIds;
    private final DispatcherGateway dispatcherGateway;
    private final ScheduledExecutor retryExecutor;

    public EmbeddedExecutorServiceLoader(Collection<JobID> submittedJobIds, DispatcherGateway dispatcherGateway, ScheduledExecutor retryExecutor) {
        this.submittedJobIds = (Collection)Preconditions.checkNotNull(submittedJobIds);
        this.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
        this.retryExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)retryExecutor);
    }

    public PipelineExecutorFactory getExecutorFactory(Configuration configuration) {
        return new EmbeddedExecutorFactory(this.submittedJobIds, this.dispatcherGateway, this.retryExecutor);
    }

    public Stream<String> getExecutorNames() {
        return Stream.builder().add("embedded").build();
    }
}

