/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialects;
import org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcLookupOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcReadOptions;
import org.apache.flink.connector.jdbc.table.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSink;
import org.apache.flink.connector.jdbc.table.JdbcDynamicTableSource;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class JdbcDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "jdbc";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        this.validateConfigOptions(config);
        org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions jdbcOptions = this.getJdbcOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new JdbcDynamicTableSink(jdbcOptions, this.getJdbcExecutionOptions(config), this.getJdbcDmlOptions(jdbcOptions, physicalSchema), physicalSchema);
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig config = helper.getOptions();
        helper.validate();
        this.validateConfigOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getCatalogTable().getSchema());
        return new JdbcDynamicTableSource(this.getJdbcOptions(helper.getOptions()), this.getJdbcReadOptions(helper.getOptions()), this.getJdbcLookupOptions(helper.getOptions()), physicalSchema);
    }

    private org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions getJdbcOptions(ReadableConfig readableConfig) {
        String url = (String)readableConfig.get(JdbcConnectorOptions.URL);
        JdbcConnectorOptions.Builder builder = org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions.builder().setDBUrl(url).setTableName((String)readableConfig.get(JdbcConnectorOptions.TABLE_NAME)).setDialect(JdbcDialects.get(url).get()).setParallelism(readableConfig.getOptional(JdbcConnectorOptions.SINK_PARALLELISM).orElse(null)).setConnectionCheckTimeoutSeconds((int)((Duration)readableConfig.get(JdbcConnectorOptions.MAX_RETRY_TIMEOUT)).getSeconds());
        readableConfig.getOptional(JdbcConnectorOptions.DRIVER).ifPresent(builder::setDriverName);
        readableConfig.getOptional(JdbcConnectorOptions.USERNAME).ifPresent(builder::setUsername);
        readableConfig.getOptional(JdbcConnectorOptions.PASSWORD).ifPresent(builder::setPassword);
        return builder.build();
    }

    private JdbcReadOptions getJdbcReadOptions(ReadableConfig readableConfig) {
        Optional partitionColumnName = readableConfig.getOptional(JdbcConnectorOptions.SCAN_PARTITION_COLUMN);
        JdbcReadOptions.Builder builder = JdbcReadOptions.builder();
        if (partitionColumnName.isPresent()) {
            builder.setPartitionColumnName((String)partitionColumnName.get());
            builder.setPartitionLowerBound((Long)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND));
            builder.setPartitionUpperBound((Long)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND));
            builder.setNumPartitions((Integer)readableConfig.get(JdbcConnectorOptions.SCAN_PARTITION_NUM));
        }
        readableConfig.getOptional(JdbcConnectorOptions.SCAN_FETCH_SIZE).ifPresent(builder::setFetchSize);
        builder.setAutoCommit((Boolean)readableConfig.get(JdbcConnectorOptions.SCAN_AUTO_COMMIT));
        return builder.build();
    }

    private JdbcLookupOptions getJdbcLookupOptions(ReadableConfig readableConfig) {
        return new JdbcLookupOptions((Long)readableConfig.get(JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS), ((Duration)readableConfig.get(JdbcConnectorOptions.LOOKUP_CACHE_TTL)).toMillis(), (Integer)readableConfig.get(JdbcConnectorOptions.LOOKUP_MAX_RETRIES));
    }

    private JdbcExecutionOptions getJdbcExecutionOptions(ReadableConfig config) {
        JdbcExecutionOptions.Builder builder = new JdbcExecutionOptions.Builder();
        builder.withBatchSize((Integer)config.get(JdbcConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS));
        builder.withBatchIntervalMs(((Duration)config.get(JdbcConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        builder.withMaxRetries((Integer)config.get(JdbcConnectorOptions.SINK_MAX_RETRIES));
        return builder.build();
    }

    private JdbcDmlOptions getJdbcDmlOptions(org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions jdbcOptions, TableSchema schema) {
        String[] keyFields = schema.getPrimaryKey().map(pk -> pk.getColumns().toArray(new String[0])).orElse(null);
        return JdbcDmlOptions.builder().withTableName(jdbcOptions.getTableName()).withDialect(jdbcOptions.getDialect()).withFieldNames(schema.getFieldNames()).withKeyFields(keyFields).build();
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet requiredOptions = new HashSet();
        requiredOptions.add(JdbcConnectorOptions.URL);
        requiredOptions.add(JdbcConnectorOptions.TABLE_NAME);
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet optionalOptions = new HashSet();
        optionalOptions.add(JdbcConnectorOptions.DRIVER);
        optionalOptions.add(JdbcConnectorOptions.USERNAME);
        optionalOptions.add(JdbcConnectorOptions.PASSWORD);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_COLUMN);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND);
        optionalOptions.add(JdbcConnectorOptions.SCAN_PARTITION_NUM);
        optionalOptions.add(JdbcConnectorOptions.SCAN_FETCH_SIZE);
        optionalOptions.add(JdbcConnectorOptions.SCAN_AUTO_COMMIT);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_CACHE_TTL);
        optionalOptions.add(JdbcConnectorOptions.LOOKUP_MAX_RETRIES);
        optionalOptions.add(JdbcConnectorOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        optionalOptions.add(JdbcConnectorOptions.SINK_BUFFER_FLUSH_INTERVAL);
        optionalOptions.add(JdbcConnectorOptions.SINK_MAX_RETRIES);
        optionalOptions.add(JdbcConnectorOptions.SINK_PARALLELISM);
        optionalOptions.add(JdbcConnectorOptions.MAX_RETRY_TIMEOUT);
        return optionalOptions;
    }

    private void validateConfigOptions(ReadableConfig config) {
        long upperBound;
        long lowerBound;
        String jdbcUrl = (String)config.get(JdbcConnectorOptions.URL);
        Optional<JdbcDialect> dialect = JdbcDialects.get(jdbcUrl);
        Preconditions.checkState((boolean)dialect.isPresent(), (Object)("Cannot handle such jdbc url: " + jdbcUrl));
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.USERNAME, JdbcConnectorOptions.PASSWORD});
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.SCAN_PARTITION_COLUMN, JdbcConnectorOptions.SCAN_PARTITION_NUM, JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND, JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND});
        if (config.getOptional(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND).isPresent() && config.getOptional(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND).isPresent() && (lowerBound = ((Long)config.get(JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND)).longValue()) > (upperBound = ((Long)config.get(JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND)).longValue())) {
            throw new IllegalArgumentException(String.format("'%s'='%s' must not be larger than '%s'='%s'.", JdbcConnectorOptions.SCAN_PARTITION_LOWER_BOUND.key(), lowerBound, JdbcConnectorOptions.SCAN_PARTITION_UPPER_BOUND.key(), upperBound));
        }
        this.checkAllOrNone(config, new ConfigOption[]{JdbcConnectorOptions.LOOKUP_CACHE_MAX_ROWS, JdbcConnectorOptions.LOOKUP_CACHE_TTL});
        if ((Integer)config.get(JdbcConnectorOptions.LOOKUP_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", JdbcConnectorOptions.LOOKUP_MAX_RETRIES.key(), config.get(JdbcConnectorOptions.LOOKUP_MAX_RETRIES)));
        }
        if ((Integer)config.get(JdbcConnectorOptions.SINK_MAX_RETRIES) < 0) {
            throw new IllegalArgumentException(String.format("The value of '%s' option shouldn't be negative, but is %s.", JdbcConnectorOptions.SINK_MAX_RETRIES.key(), config.get(JdbcConnectorOptions.SINK_MAX_RETRIES)));
        }
        if (((Duration)config.get(JdbcConnectorOptions.MAX_RETRY_TIMEOUT)).getSeconds() <= 0L) {
            throw new IllegalArgumentException(String.format("The value of '%s' option must be in second granularity and shouldn't be smaller than 1 second, but is %s.", JdbcConnectorOptions.MAX_RETRY_TIMEOUT.key(), config.get(ConfigOptions.key((String)JdbcConnectorOptions.MAX_RETRY_TIMEOUT.key()).stringType().noDefaultValue())));
        }
    }

    private void checkAllOrNone(ReadableConfig config, ConfigOption<?>[] configOptions) {
        int presentCount = 0;
        for (ConfigOption<?> configOption : configOptions) {
            if (!config.getOptional(configOption).isPresent()) continue;
            ++presentCount;
        }
        CharSequence[] propertyNames = (String[])Arrays.stream(configOptions).map(ConfigOption::key).toArray(String[]::new);
        Preconditions.checkArgument((configOptions.length == presentCount || presentCount == 0 ? 1 : 0) != 0, (Object)("Either all or none of the following options should be provided:\n" + String.join((CharSequence)"\n", propertyNames)));
    }
}

