/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.jdbc.JdbcInputFormat;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcLookupOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcReadOptions;
import org.apache.flink.connector.jdbc.split.JdbcNumericBetweenParametersProvider;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.table.JdbcLookupFunction;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.functions.AsyncTableFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.sources.LookupableTableSource;
import org.apache.flink.table.sources.ProjectableTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JdbcTableSource
implements StreamTableSource<Row>,
ProjectableTableSource<Row>,
LookupableTableSource<Row> {
    private final JdbcConnectorOptions options;
    private final JdbcReadOptions readOptions;
    private final JdbcLookupOptions lookupOptions;
    private final TableSchema schema;
    private final int[] selectFields;
    private final DataType producedDataType;

    private JdbcTableSource(JdbcConnectorOptions options, JdbcReadOptions readOptions, JdbcLookupOptions lookupOptions, TableSchema schema) {
        this(options, readOptions, lookupOptions, schema, (int[])null);
    }

    private JdbcTableSource(JdbcConnectorOptions options, JdbcReadOptions readOptions, JdbcLookupOptions lookupOptions, TableSchema schema, int[] selectFields) {
        this.options = options;
        this.readOptions = readOptions;
        this.lookupOptions = lookupOptions;
        this.schema = schema;
        this.selectFields = selectFields;
        DataType[] schemaDataTypes = schema.getFieldDataTypes();
        String[] schemaFieldNames = schema.getFieldNames();
        if (selectFields != null) {
            DataType[] dataTypes = new DataType[selectFields.length];
            String[] fieldNames = new String[selectFields.length];
            for (int i = 0; i < selectFields.length; ++i) {
                dataTypes[i] = schemaDataTypes[selectFields[i]];
                fieldNames[i] = schemaFieldNames[selectFields[i]];
            }
            this.producedDataType = TableSchema.builder().fields(fieldNames, dataTypes).build().toRowDataType();
        } else {
            this.producedDataType = schema.toRowDataType();
        }
    }

    public boolean isBounded() {
        return true;
    }

    public DataStream<Row> getDataStream(StreamExecutionEnvironment execEnv) {
        return execEnv.createInput((InputFormat)this.getInputFormat(), (TypeInformation)((RowTypeInfo)TypeConversions.fromDataTypeToLegacyInfo((DataType)this.producedDataType))).name(this.explainSource());
    }

    public TableFunction<Row> getLookupFunction(String[] lookupKeys) {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)TypeConversions.fromDataTypeToLegacyInfo((DataType)this.producedDataType);
        return JdbcLookupFunction.builder().setOptions(this.options).setLookupOptions(this.lookupOptions).setFieldTypes(rowTypeInfo.getFieldTypes()).setFieldNames(rowTypeInfo.getFieldNames()).setKeyNames(lookupKeys).build();
    }

    public DataType getProducedDataType() {
        return this.producedDataType;
    }

    public TableSource<Row> projectFields(int[] fields) {
        return new JdbcTableSource(this.options, this.readOptions, this.lookupOptions, this.schema, fields);
    }

    public AsyncTableFunction<Row> getAsyncLookupFunction(String[] lookupKeys) {
        throw new UnsupportedOperationException();
    }

    public boolean isAsyncEnabled() {
        return false;
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public String explainSource() {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)TypeConversions.fromDataTypeToLegacyInfo((DataType)this.producedDataType);
        return TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])rowTypeInfo.getFieldNames());
    }

    public static Builder builder() {
        return new Builder();
    }

    private JdbcInputFormat getInputFormat() {
        RowTypeInfo rowTypeInfo = (RowTypeInfo)TypeConversions.fromDataTypeToLegacyInfo((DataType)this.producedDataType);
        JdbcInputFormat.JdbcInputFormatBuilder builder = JdbcInputFormat.buildJdbcInputFormat().setDrivername(this.options.getDriverName()).setDBUrl(this.options.getDbURL()).setRowTypeInfo(new RowTypeInfo(rowTypeInfo.getFieldTypes(), rowTypeInfo.getFieldNames()));
        this.options.getUsername().ifPresent(builder::setUsername);
        this.options.getPassword().ifPresent(builder::setPassword);
        if (this.readOptions.getFetchSize() != 0) {
            builder.setFetchSize(this.readOptions.getFetchSize());
        }
        JdbcDialect dialect = this.options.getDialect();
        String query = this.getBaseQueryStatement(rowTypeInfo);
        if (this.readOptions.getPartitionColumnName().isPresent()) {
            long lowerBound = this.readOptions.getPartitionLowerBound().get();
            long upperBound = this.readOptions.getPartitionUpperBound().get();
            int numPartitions = this.readOptions.getNumPartitions().get();
            builder.setParametersProvider(new JdbcNumericBetweenParametersProvider(lowerBound, upperBound).ofBatchNum(numPartitions));
            query = query + " WHERE " + dialect.quoteIdentifier(this.readOptions.getPartitionColumnName().get()) + " BETWEEN ? AND ?";
        }
        builder.setQuery(query);
        return builder.finish();
    }

    private String getBaseQueryStatement(RowTypeInfo rowTypeInfo) {
        return this.readOptions.getQuery().orElseGet(() -> FieldNamedPreparedStatementImpl.parseNamedStatement(this.options.getDialect().getSelectFromStatement(this.options.getTableName(), rowTypeInfo.getFieldNames(), new String[0]), new HashMap<String, List<Integer>>()));
    }

    public boolean equals(Object o) {
        if (o instanceof JdbcTableSource) {
            JdbcTableSource source = (JdbcTableSource)o;
            return Objects.equals(this.options, source.options) && Objects.equals(this.readOptions, source.readOptions) && Objects.equals(this.lookupOptions, source.lookupOptions) && Objects.equals(this.schema, source.schema) && Arrays.equals(this.selectFields, source.selectFields);
        }
        return false;
    }

    public static class Builder {
        private JdbcConnectorOptions options;
        private JdbcReadOptions readOptions;
        private JdbcLookupOptions lookupOptions;
        protected TableSchema schema;

        public Builder setOptions(JdbcConnectorOptions options) {
            this.options = options;
            return this;
        }

        public Builder setReadOptions(JdbcReadOptions readOptions) {
            this.readOptions = readOptions;
            return this;
        }

        public Builder setLookupOptions(JdbcLookupOptions lookupOptions) {
            this.lookupOptions = lookupOptions;
            return this;
        }

        public Builder setSchema(TableSchema schema) {
            this.schema = JdbcTypeUtil.normalizeTableSchema(schema);
            return this;
        }

        public JdbcTableSource build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.schema, (String)"No schema supplied.");
            if (this.readOptions == null) {
                this.readOptions = JdbcReadOptions.builder().build();
            }
            if (this.lookupOptions == null) {
                this.lookupOptions = JdbcLookupOptions.builder().build();
            }
            return new JdbcTableSource(this.options, this.readOptions, this.lookupOptions, this.schema);
        }
    }
}

