/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.connector.jdbc.internal.GenericJdbcSinkFunction;
import org.apache.flink.connector.jdbc.internal.JdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcConnectorOptions;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class JdbcUpsertTableSink
implements UpsertStreamTableSink<Row> {
    private final TableSchema schema;
    private final JdbcConnectorOptions options;
    private final int flushMaxSize;
    private final long flushIntervalMills;
    private final int maxRetryTime;
    private String[] keyFields;
    private boolean isAppendOnly;

    private JdbcUpsertTableSink(TableSchema schema, JdbcConnectorOptions options, int flushMaxSize, long flushIntervalMills, int maxRetryTime) {
        this.schema = TableSchemaUtils.checkOnlyPhysicalColumns((TableSchema)schema);
        this.options = options;
        this.flushMaxSize = flushMaxSize;
        this.flushIntervalMills = flushIntervalMills;
        this.maxRetryTime = maxRetryTime;
    }

    private JdbcOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>> newFormat() {
        if (!(this.isAppendOnly || this.keyFields != null && this.keyFields.length != 0)) {
            throw new UnsupportedOperationException("JdbcUpsertTableSink can not support ");
        }
        int[] jdbcSqlTypes = Arrays.stream(this.schema.getFieldTypes()).mapToInt(JdbcTypeUtil::typeInformationToSqlType).toArray();
        return JdbcOutputFormat.builder().setOptions(this.options).setFieldNames(this.schema.getFieldNames()).setFlushMaxSize(this.flushMaxSize).setFlushIntervalMills(this.flushIntervalMills).setMaxRetryTimes(this.maxRetryTime).setFieldTypes(jdbcSqlTypes).setKeyFields(this.keyFields).build();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        return dataStream.addSink(new GenericJdbcSinkFunction<Tuple2<Boolean, Row>>(this.newFormat())).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.schema.getFieldNames()));
    }

    public void setKeyFields(String[] keys) {
        this.keyFields = keys;
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
        this.isAppendOnly = isAppendOnly;
    }

    public TypeInformation<Tuple2<Boolean, Row>> getOutputType() {
        return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }

    public TypeInformation<Row> getRecordType() {
        return new RowTypeInfo(this.schema.getFieldTypes(), this.schema.getFieldNames());
    }

    public String[] getFieldNames() {
        return this.schema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.schema.getFieldTypes();
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        JdbcUpsertTableSink copy = new JdbcUpsertTableSink(this.schema, this.options, this.flushMaxSize, this.flushIntervalMills, this.maxRetryTime);
        copy.keyFields = this.keyFields;
        return copy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof JdbcUpsertTableSink) {
            JdbcUpsertTableSink sink = (JdbcUpsertTableSink)o;
            return Objects.equals(this.schema, sink.schema) && Objects.equals(this.options, sink.options) && Objects.equals(this.flushMaxSize, sink.flushMaxSize) && Objects.equals(this.flushIntervalMills, sink.flushIntervalMills) && Objects.equals(this.maxRetryTime, sink.maxRetryTime) && Arrays.equals(this.keyFields, sink.keyFields) && Objects.equals(this.isAppendOnly, sink.isAppendOnly);
        }
        return false;
    }

    public static class Builder {
        protected TableSchema schema;
        private JdbcConnectorOptions options;
        protected int flushMaxSize = 5000;
        protected long flushIntervalMills = 0L;
        protected int maxRetryTimes = 3;

        public Builder setTableSchema(TableSchema schema) {
            this.schema = JdbcTypeUtil.normalizeTableSchema(schema);
            return this;
        }

        public Builder setOptions(JdbcConnectorOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.flushMaxSize = flushMaxSize;
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.flushIntervalMills = flushIntervalMills;
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public JdbcUpsertTableSink build() {
            Preconditions.checkNotNull((Object)this.schema, (String)"No schema supplied.");
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            return new JdbcUpsertTableSink(this.schema, this.options, this.flushMaxSize, this.flushIntervalMills, this.maxRetryTimes);
        }
    }
}

