/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.flink.connector.base.source.utils.SerdeUtils;
import org.apache.flink.connector.kafka.source.enumerator.KafkaSourceEnumState;
import org.apache.flink.connector.kafka.source.split.KafkaPartitionSplitSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;

public class KafkaSourceEnumStateSerializer
implements SimpleVersionedSerializer<KafkaSourceEnumState> {
    private static final int CURRENT_VERSION = 0;

    public int getVersion() {
        return 0;
    }

    public byte[] serialize(KafkaSourceEnumState enumState) throws IOException {
        return SerdeUtils.serializeSplitAssignments(enumState.getCurrentAssignment(), (SimpleVersionedSerializer)new KafkaPartitionSplitSerializer());
    }

    public KafkaSourceEnumState deserialize(int version, byte[] serialized) throws IOException {
        if (version == 0) {
            Map currentPartitionAssignment = SerdeUtils.deserializeSplitAssignments((byte[])serialized, (SimpleVersionedSerializer)new KafkaPartitionSplitSerializer(), HashSet::new);
            return new KafkaSourceEnumState(currentPartitionAssignment);
        }
        throw new IOException(String.format("The bytes are serialized with version %d, while this deserializer only supports version up to %d", version, 0));
    }
}

