/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.reader.deserializer;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializer;
import org.apache.flink.util.Collector;
import org.apache.flink.util.InstantiationUtil;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValueDeserializerWrapper<T>
implements KafkaRecordDeserializer<T> {
    private static final long serialVersionUID = 5409547407386004054L;
    private static final Logger LOG = LoggerFactory.getLogger(ValueDeserializerWrapper.class);
    private final String deserializerClass;
    private final Map<String, String> config;
    private transient Deserializer<T> deserializer;

    ValueDeserializerWrapper(Class<? extends Deserializer<T>> deserializerClass, Map<String, String> config) {
        this.deserializerClass = deserializerClass.getName();
        this.config = config;
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> record, Collector<T> collector) throws Exception {
        if (this.deserializer == null) {
            this.deserializer = (Deserializer)InstantiationUtil.instantiate((String)this.deserializerClass, Deserializer.class, (ClassLoader)this.getClass().getClassLoader());
            if (this.deserializer instanceof Configurable) {
                ((Configurable)this.deserializer).configure(this.config);
            }
        }
        Object value = this.deserializer.deserialize(record.topic(), (byte[])record.value());
        LOG.trace("Deserialized [partition: {}-{}, offset: {}, timestamp: {}, value: {}]", new Object[]{record.topic(), record.partition(), record.offset(), record.timestamp(), value});
        collector.collect(value);
    }

    public TypeInformation<T> getProducedType() {
        return TypeExtractor.createTypeInfo(Deserializer.class, this.deserializer.getClass(), (int)0, null, null);
    }
}

