/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaContextAware;
import org.apache.flink.streaming.connectors.kafka.KafkaSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.clients.producer.ProducerRecord;

class DynamicKafkaSerializationSchema
implements KafkaSerializationSchema<RowData>,
KafkaContextAware<RowData> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final FlinkKafkaPartitioner<RowData> partitioner;
    private final String topic;
    @Nullable
    private final SerializationSchema<RowData> keySerialization;
    private final SerializationSchema<RowData> valueSerialization;
    private final RowData.FieldGetter[] keyFieldGetters;
    private final RowData.FieldGetter[] valueFieldGetters;
    private final boolean hasMetadata;
    private final boolean upsertMode;
    private final int[] metadataPositions;
    private int[] partitions;
    private int parallelInstanceId;
    private int numParallelInstances;

    DynamicKafkaSerializationSchema(String topic, @Nullable FlinkKafkaPartitioner<RowData> partitioner, @Nullable SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization, RowData.FieldGetter[] keyFieldGetters, RowData.FieldGetter[] valueFieldGetters, boolean hasMetadata, int[] metadataPositions, boolean upsertMode) {
        if (upsertMode) {
            Preconditions.checkArgument((keySerialization != null && keyFieldGetters.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for serialization schema.");
        }
        this.topic = topic;
        this.partitioner = partitioner;
        this.keySerialization = keySerialization;
        this.valueSerialization = valueSerialization;
        this.keyFieldGetters = keyFieldGetters;
        this.valueFieldGetters = valueFieldGetters;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.upsertMode = upsertMode;
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        if (this.keySerialization != null) {
            this.keySerialization.open(context);
        }
        this.valueSerialization.open(context);
        if (this.partitioner != null) {
            this.partitioner.open(this.parallelInstanceId, this.numParallelInstances);
        }
    }

    @Override
    public ProducerRecord<byte[], byte[]> serialize(RowData consumedRow, @Nullable Long timestamp) {
        byte[] valueSerialized;
        byte[] keySerialized;
        if (this.keySerialization == null && !this.hasMetadata) {
            byte[] valueSerialized2 = this.valueSerialization.serialize((Object)consumedRow);
            return new ProducerRecord(this.topic, this.extractPartition(consumedRow, null, valueSerialized2), null, (Object)valueSerialized2);
        }
        if (this.keySerialization == null) {
            keySerialized = null;
        } else {
            RowData keyRow = DynamicKafkaSerializationSchema.createProjectedRow(consumedRow, RowKind.INSERT, this.keyFieldGetters);
            keySerialized = this.keySerialization.serialize((Object)keyRow);
        }
        RowKind kind = consumedRow.getRowKind();
        RowData valueRow = DynamicKafkaSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
        if (this.upsertMode) {
            if (kind == RowKind.DELETE || kind == RowKind.UPDATE_BEFORE) {
                valueSerialized = null;
            } else {
                valueRow.setRowKind(RowKind.INSERT);
                valueSerialized = this.valueSerialization.serialize((Object)valueRow);
            }
        } else {
            valueSerialized = this.valueSerialization.serialize((Object)valueRow);
        }
        return new ProducerRecord(this.topic, this.extractPartition(consumedRow, keySerialized, valueSerialized), (Long)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.TIMESTAMP), (Object)keySerialized, (Object)valueSerialized, (Iterable)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.HEADERS));
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    @Override
    public void setPartitions(int[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public String getTargetTopic(RowData element) {
        return this.topic;
    }

    private <T> T readMetadata(RowData consumedRow, KafkaDynamicSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }

    private Integer extractPartition(RowData consumedRow, @Nullable byte[] keySerialized, byte[] valueSerialized) {
        if (this.partitioner != null) {
            return this.partitioner.partition(consumedRow, keySerialized, valueSerialized, this.topic, this.partitions);
        }
        return null;
    }

    private static RowData createProjectedRow(RowData consumedRow, RowKind kind, RowData.FieldGetter[] fieldGetters) {
        int arity = fieldGetters.length;
        GenericRowData genericRowData = new GenericRowData(kind, arity);
        for (int fieldPos = 0; fieldPos < arity; ++fieldPos) {
            genericRowData.setField(fieldPos, fieldGetters[fieldPos].getFieldOrNull(consumedRow));
        }
        return genericRowData;
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(RowData var1, int var2);
    }
}

