/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.lib.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.lib.util.IteratorSourceSplit;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.util.Preconditions;

public class IteratorSourceReader<E, IterT extends Iterator<E>, SplitT extends IteratorSourceSplit<E, IterT>>
implements SourceReader<E, SplitT> {
    private final SourceReaderContext context;
    private CompletableFuture<Void> availability;
    @Nullable
    private IterT iterator;
    @Nullable
    private SplitT currentSplit;
    private final Queue<SplitT> remainingSplits;
    private boolean noMoreSplits;

    public IteratorSourceReader(SourceReaderContext context) {
        this.context = Preconditions.checkNotNull(context);
        this.availability = new CompletableFuture();
        this.remainingSplits = new ArrayDeque<SplitT>();
    }

    @Override
    public void start() {
        if (this.remainingSplits.isEmpty()) {
            this.context.sendSplitRequest();
        }
    }

    @Override
    public InputStatus pollNext(ReaderOutput<E> output) {
        if (this.iterator != null) {
            if (this.iterator.hasNext()) {
                output.collect(this.iterator.next());
                return InputStatus.MORE_AVAILABLE;
            }
            this.finishSplit();
        }
        return this.tryMoveToNextSplit();
    }

    private void finishSplit() {
        this.iterator = null;
        this.currentSplit = null;
        if (this.remainingSplits.isEmpty() && !this.noMoreSplits) {
            this.context.sendSplitRequest();
        }
    }

    private InputStatus tryMoveToNextSplit() {
        this.currentSplit = (IteratorSourceSplit)this.remainingSplits.poll();
        if (this.currentSplit != null) {
            this.iterator = this.currentSplit.getIterator();
            return InputStatus.MORE_AVAILABLE;
        }
        if (this.noMoreSplits) {
            return InputStatus.END_OF_INPUT;
        }
        if (this.availability.isDone()) {
            this.availability = new CompletableFuture();
        }
        return InputStatus.NOTHING_AVAILABLE;
    }

    @Override
    public CompletableFuture<Void> isAvailable() {
        return this.availability;
    }

    @Override
    public void addSplits(List<SplitT> splits) {
        this.remainingSplits.addAll(splits);
        this.availability.complete(null);
    }

    @Override
    public void notifyNoMoreSplits() {
        this.noMoreSplits = true;
        this.availability.complete(null);
    }

    @Override
    public List<SplitT> snapshotState(long checkpointId) {
        if (this.currentSplit == null && this.remainingSplits.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allSplits = new ArrayList(1 + this.remainingSplits.size());
        if (this.iterator != null && this.iterator.hasNext()) {
            assert (this.currentSplit != null);
            IteratorSourceSplit inProgressSplit = this.currentSplit.getUpdatedSplitForIterator(this.iterator);
            allSplits.add(inProgressSplit);
        }
        allSplits.addAll(this.remainingSplits);
        return allSplits;
    }

    @Override
    public void close() throws Exception {
    }
}

